"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardsLandingCalloutComponent = exports.DashboardsLandingCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _links = require("@kbn/security-solution-navigation/links");
var _react2 = require("@emotion/react");
var _constants = require("../../navigation/links/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const linkAnchorCss = (0, _react2.css)`
  text-decoration: underline;
`;
const DashboardsLandingCalloutComponent = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "visArea",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.dashboardsLandingCallout.title",
      defaultMessage: "Building a dashboard or visualization? Create and add {maps} or choose from the {visualizationLibrary}",
      values: {
        maps: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
          id: _constants.ExternalPageName.maps,
          css: linkAnchorCss
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolutionServerless.dashboardsLandingCallout.maps",
          defaultMessage: "Maps"
        })),
        visualizationLibrary: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
          id: _constants.ExternalPageName.visualize,
          css: linkAnchorCss
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolutionServerless.dashboardsLandingCallout.visualizeLibrary",
          defaultMessage: "Visualize library"
        }))
      }
    }))
  });
};
exports.DashboardsLandingCalloutComponent = DashboardsLandingCalloutComponent;
DashboardsLandingCalloutComponent.displayName = 'DashboardsLandingCalloutComponent';
const DashboardsLandingCallout = /*#__PURE__*/_react.default.memo(DashboardsLandingCalloutComponent);

// eslint-disable-next-line import/no-default-export
exports.DashboardsLandingCallout = DashboardsLandingCallout;
var _default = DashboardsLandingCallout;
exports.default = _default;