"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserName = void 0;
var _react = require("react");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserName = () => {
  const [userName, setUserName] = (0, _react.useState)();
  const {
    services: {
      security: {
        authc
      }
    }
  } = (0, _services.useKibana)();
  (0, _react.useEffect)(() => {
    const getUser = async () => {
      const {
        username
      } = await authc.getCurrentUser();
      setUserName(username);
    };
    getUser();
  });
  return userName;
};
exports.useUserName = useUserName;