"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialDashboardMetrics = exports.getSecurityTag = exports.getDashboardMetrics = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecurityTag = async ({
  savedObjectsClient,
  logger
}) => {
  const tagResponse = await savedObjectsClient.find({
    type: 'tag',
    searchFields: ['name'],
    search: _constants.SECURITY_TAG_NAME
  });
  // The search query returns partial matches, we need to find the exact tag name
  return tagResponse.saved_objects.find(({
    attributes
  }) => attributes.name === _constants.SECURITY_TAG_NAME);
};
exports.getSecurityTag = getSecurityTag;
const initialDashboardMetrics = {};
exports.initialDashboardMetrics = initialDashboardMetrics;
const getDashboardMetrics = async ({
  savedObjectsClient,
  logger
}) => {
  const tag = await getSecurityTag({
    savedObjectsClient,
    logger
  });
  const tagId = tag === null || tag === void 0 ? void 0 : tag.id;
  if (!tagId) {
    logger.debug(`No ${_constants.SECURITY_TAG_NAME} tag found, therefore not collecting telemetry from it`);
    return initialDashboardMetrics;
  }
  const dashboardsResponse = await savedObjectsClient.find({
    type: 'dashboard',
    hasReference: {
      id: tagId,
      type: 'tag'
    }
  });
  return {
    dashboard_tag: {
      created_at: tag.created_at,
      linked_dashboards_count: dashboardsResponse.saved_objects.length
    },
    dashboards: dashboardsResponse.saved_objects.map(d => {
      var _d$error, _d$error2, _d$error3, _d$error4;
      return {
        created_at: d.created_at,
        dashboard_id: d.id,
        ...(d !== null && d !== void 0 && (_d$error = d.error) !== null && _d$error !== void 0 && _d$error.message ? {
          error_message: d === null || d === void 0 ? void 0 : (_d$error2 = d.error) === null || _d$error2 === void 0 ? void 0 : _d$error2.message
        } : {}),
        ...(d !== null && d !== void 0 && (_d$error3 = d.error) !== null && _d$error3 !== void 0 && _d$error3.statusCode ? {
          error_status_code: d === null || d === void 0 ? void 0 : (_d$error4 = d.error) === null || _d$error4 === void 0 ? void 0 : _d$error4.statusCode
        } : {})
      };
    })
  };
};
exports.getDashboardMetrics = getDashboardMetrics;