"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endpointSearchStrategyProvider = void 0;
var _operators = require("rxjs/operators");
var _server = require("@kbn/data-plugin/server");
var _rxjs = require("rxjs");
var _factory = require("./factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointSearchStrategyProvider = (data, endpointContext) => {
  const es = data.search.searchAsInternalUser;
  return {
    search: (request, options, deps) => {
      if (request.factoryQueryType == null) {
        throw new Error('factoryQueryType is required');
      }
      return (0, _rxjs.from)(endpointContext.service.getEndpointAuthz(deps.request)).pipe((0, _operators.mergeMap)(authz => {
        const queryFactory = _factory.endpointFactory[request.factoryQueryType];
        const strictRequest = {
          factoryQueryType: request.factoryQueryType,
          sort: request.sort,
          ...('alertIds' in request ? {
            alertIds: request.alertIds
          } : {}),
          ...('agentId' in request ? {
            agentId: request.agentId
          } : {}),
          ...('expiration' in request ? {
            expiration: request.expiration
          } : {}),
          ...('actionId' in request ? {
            actionId: request.actionId
          } : {}),
          ...('agents' in request ? {
            agents: request.agents
          } : {})
        };
        const dsl = queryFactory.buildDsl(strictRequest, {
          authz
        });
        return es.search({
          ...strictRequest,
          params: dsl
        }, options, deps).pipe((0, _operators.map)(response => {
          return {
            ...response,
            ...{
              rawResponse: (0, _server.shimHitsTotal)(response.rawResponse, options)
            }
          };
        }), (0, _operators.mergeMap)(esSearchRes => queryFactory.parse(request, esSearchRes, {
          authz
        })));
      }));
    },
    cancel: async (id, options, deps) => {
      if (es.cancel) {
        return es.cancel(id, options, deps);
      }
    }
  };
};
exports.endpointSearchStrategyProvider = endpointSearchStrategyProvider;