"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapEsqlAlerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _reason_formatters = require("../utils/reason_formatters");
var _build_bulk_body = require("../factories/utils/build_bulk_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapEsqlAlerts = ({
  results,
  spaceId,
  completeRule,
  mergeStrategy,
  alertTimestampOverride,
  ruleExecutionLogger,
  publicBaseUrl,
  tuple,
  sourceDocuments,
  isRuleAggregating
}) => {
  const wrapped = results.map((document, i) => {
    var _sourceDocuments$_id;
    const ruleRunId = tuple.from.toISOString() + tuple.to.toISOString();

    // for aggregating rules when metadata _id is present, generate alert based on ES document event id
    const id = !isRuleAggregating && document._id ? (0, _objectHash.default)([document._id, document._version, document._index, `${spaceId}:${completeRule.alertId}`]) : (0, _objectHash.default)([ruleRunId, completeRule.ruleParams.query, `${spaceId}:${completeRule.alertId}`, i]);

    // metadata fields need to be excluded from source, otherwise alerts creation fails
    const {
      _id,
      _version,
      _index,
      ...source
    } = document;
    const baseAlert = (0, _build_bulk_body.buildBulkBody)(spaceId, completeRule, {
      _source: source,
      fields: _id ? (_sourceDocuments$_id = sourceDocuments[_id]) === null || _sourceDocuments$_id === void 0 ? void 0 : _sourceDocuments$_id.fields : undefined,
      _id: _id !== null && _id !== void 0 ? _id : '',
      _index: _index !== null && _index !== void 0 ? _index : ''
    }, mergeStrategy, [], true, _reason_formatters.buildReasonMessageForNewTermsAlert, [], alertTimestampOverride, ruleExecutionLogger, id, publicBaseUrl);
    return {
      _id: id,
      _index: _index !== null && _index !== void 0 ? _index : '',
      _source: {
        ...baseAlert
      }
    };
  });
  return wrapped;
};
exports.wrapEsqlAlerts = wrapEsqlAlerts;