"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performEsqlRequest = void 0;
var _server = require("@kbn/kibana-utils-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const performEsqlRequest = async ({
  esClient,
  requestParams
}) => {
  const search = async () => {
    try {
      const rawResponse = await esClient.transport.request({
        method: 'POST',
        path: '/_query',
        body: {
          ...requestParams
        }
      });
      return {
        rawResponse,
        isPartial: false,
        isRunning: false
      };
    } catch (e) {
      throw (0, _server.getKbnServerError)(e);
    }
  };
  return (await search()).rawResponse;
};
exports.performEsqlRequest = performEsqlRequest;