"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleSchedule = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _common = require("@kbn/alerting-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleSchedule = rule => {
  var _rule$interval, _rule$from, _rule$to, _rule$meta, _ruleMeta$from;
  const interval = (_rule$interval = rule.interval) !== null && _rule$interval !== void 0 ? _rule$interval : '5m';
  const from = (_rule$from = rule.from) !== null && _rule$from !== void 0 ? _rule$from : 'now-6m';
  const to = (_rule$to = rule.to) !== null && _rule$to !== void 0 ? _rule$to : 'now';

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const ruleMeta = (_rule$meta = rule.meta) !== null && _rule$meta !== void 0 ? _rule$meta : {};
  const lookbackFromMeta = String((_ruleMeta$from = ruleMeta.from) !== null && _ruleMeta$from !== void 0 ? _ruleMeta$from : '');
  const intervalDuration = parseInterval(interval);
  const lookbackFromMetaDuration = parseInterval(lookbackFromMeta);
  const driftToleranceDuration = parseDriftTolerance(from, to);
  if (lookbackFromMetaDuration != null) {
    if (intervalDuration != null) {
      return {
        interval,
        lookback: lookbackFromMeta
      };
    }
    return {
      interval: `Cannot parse: interval="${interval}"`,
      lookback: lookbackFromMeta
    };
  }
  if (intervalDuration == null) {
    return {
      interval: `Cannot parse: interval="${interval}"`,
      lookback: `Cannot calculate due to invalid interval`
    };
  }
  if (driftToleranceDuration == null) {
    return {
      interval,
      lookback: `Cannot parse: from="${from}", to="${to}"`
    };
  }
  const lookbackDuration = _moment.default.duration().add(driftToleranceDuration).subtract(intervalDuration);
  const lookback = `${lookbackDuration.asSeconds()}s`;
  return {
    interval,
    lookback
  };
};
exports.extractRuleSchedule = extractRuleSchedule;
const parseInterval = intervalString => {
  try {
    const milliseconds = (0, _common.parseDuration)(intervalString);
    return _moment.default.duration(milliseconds);
  } catch (e) {
    return null;
  }
};
const parseDriftTolerance = (from, to) => {
  const now = new Date();
  const fromDate = parseDateMathString(from, now);
  const toDate = parseDateMathString(to, now);
  if (fromDate == null || toDate == null) {
    return null;
  }
  return _moment.default.duration(toDate.diff(fromDate));
};
const parseDateMathString = (dateMathString, now) => {
  const parsedDate = _datemath.default.parse(dateMathString, {
    forceNow: now
  });
  return parsedDate != null && parsedDate.isValid() ? parsedDate : null;
};