"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installPrebuiltRulesPackage = installPrebuiltRulesPackage;
var _constants = require("../../../../../../common/detection_engine/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Installs the prebuilt rules package of the config's specified or latest version.
 *
 * @param config Kibana config
 * @param context Request handler context
 */
async function installPrebuiltRulesPackage(config, context) {
  // Get package version from the config
  let pkgVersion = config.prebuiltRulesPackageVersion;

  // Find latest package if the version isn't specified in the config
  if (!pkgVersion) {
    // Use prerelease versions in dev environment
    const isPrerelease = context.getAppClient().getKibanaVersion().includes('-SNAPSHOT') || context.getAppClient().getKibanaBranch() === 'main';
    const result = await context.getInternalFleetServices().packages.fetchFindLatestPackage(_constants.PREBUILT_RULES_PACKAGE_NAME, {
      prerelease: isPrerelease
    });
    pkgVersion = result.version;
  }

  // Install the package
  await context.getInternalFleetServices().packages.ensureInstalledPackage({
    pkgName: _constants.PREBUILT_RULES_PACKAGE_NAME,
    pkgVersion
  });
}