"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstalledIntegrationsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _utils = require("../../../routes/utils");
var _fleet_integrations = require("../../../../../../common/api/detection_engine/fleet_integrations");
var _installed_integration_set = require("./installed_integration_set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an array of installed Fleet integrations and their packages.
 */
const getInstalledIntegrationsRoute = (router, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _fleet_integrations.GET_INSTALLED_INTEGRATIONS_URL,
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'securitySolution']);
      const fleet = ctx.securitySolution.getInternalFleetServices();
      const set = (0, _installed_integration_set.createInstalledIntegrationSet)();

      // Pulls all packages into memory just like the main fleet landing page
      // No pagination support currently, so cannot batch this call
      const allThePackages = await fleet.packages.getPackages();
      allThePackages.forEach(fleetPackage => {
        set.addPackage(fleetPackage);
      });
      const packagePolicies = await fleet.packagePolicy.list(fleet.internalReadonlySoClient, {});
      packagePolicies.items.forEach(policy => {
        set.addPackagePolicy(policy);
      });
      const installedIntegrations = set.getIntegrations();
      const body = {
        installed_integrations: installedIntegrations
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getInstalledIntegrationsRoute = getInstalledIntegrationsRoute;