"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateActionId = void 0;
var _errors = require("../../errors");
var _utils = require("../../utils");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates that a given action ID is a valid Endpoint action
 *
 * @throws
 */
const validateActionId = async (esClient, actionId) => {
  var _response$hits, _response$hits$total;
  const response = await esClient.search({
    index: _constants.ENDPOINT_ACTIONS_INDEX,
    body: {
      query: {
        bool: {
          filter: [{
            term: {
              action_id: actionId
            }
          }, {
            term: {
              input_type: 'endpoint'
            }
          }, {
            term: {
              type: 'INPUT_ACTION'
            }
          }]
        }
      }
    },
    _source: false
  }).catch(_utils.catchAndWrapError);
  if (!((_response$hits = response.hits) !== null && _response$hits !== void 0 && (_response$hits$total = _response$hits.total) !== null && _response$hits$total !== void 0 && _response$hits$total.value)) {
    throw new _errors.NotFoundError(`Action id [${actionId}] not found`, response);
  }
};
exports.validateActionId = validateActionId;