"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addErrorsToActionIfAny = void 0;
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addErrorsToActionIfAny = ({
  agents,
  licenseService,
  minimumLicenseRequired = 'basic'
}) => {
  const licenseError = (0, _validate.validateEndpointLicense)(licenseService, minimumLicenseRequired);
  const agentsError = (0, _validate.validateAgents)(agents);
  const alertActionError = licenseError || agentsError;
  if (alertActionError) {
    return {
      error: {
        code: '400',
        message: alertActionError
      }
    };
  }
};
exports.addErrorsToActionIfAny = addErrorsToActionIfAny;