"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionStateRequestHandler = void 0;
exports.registerActionStateRoutes = registerActionStateRoutes;
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Registers routes for checking state of actions routes
 */
function registerActionStateRoutes(router, endpointContext, canEncrypt) {
  router.versioned.get({
    access: 'public',
    path: _constants.ACTION_STATE_ROUTE,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '2023-10-31',
    validate: false
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canIsolateHost', 'canUnIsolateHost', 'canKillProcess', 'canSuspendProcess', 'canGetRunningProcesses', 'canAccessResponseConsole', 'canWriteExecuteOperations', 'canWriteFileOperations']
  }, endpointContext.logFactory.get('actionState'), getActionStateRequestHandler(canEncrypt)));
}
const getActionStateRequestHandler = function (canEncrypt) {
  return async (_, __, res) => {
    return res.ok({
      body: {
        data: {
          canEncrypt
        }
      }
    });
  };
};
exports.getActionStateRequestHandler = getActionStateRequestHandler;