"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineByIdSelector = exports.selectTimeline = exports.selectInsertTimeline = exports.getTimelineByIdSelector = exports.getShowCallOutUnauthorizedMsg = exports.getKqlFilterQuerySelector = exports.getKqlFilterKuerySelector = exports.dataProviderVisibilitySelector = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectTimelineById = state => state.timeline.timelineById;
const selectCallOutUnauthorizedMsg = state => state.timeline.showCallOutUnauthorizedMsg;
const selectTimeline = (state, timelineId) => state.timeline.timelineById[timelineId];
exports.selectTimeline = selectTimeline;
const selectInsertTimeline = state => state.timeline.insertTimeline;
exports.selectInsertTimeline = selectInsertTimeline;
const timelineByIdSelector = (0, _reselect.createSelector)(selectTimelineById, timelineById => timelineById);
exports.timelineByIdSelector = timelineByIdSelector;
const getShowCallOutUnauthorizedMsg = () => (0, _reselect.createSelector)(selectCallOutUnauthorizedMsg, showCallOutUnauthorizedMsg => showCallOutUnauthorizedMsg);
exports.getShowCallOutUnauthorizedMsg = getShowCallOutUnauthorizedMsg;
const getTimelineByIdSelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline);
exports.getTimelineByIdSelector = getTimelineByIdSelector;
const getKqlFilterQuerySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline && timeline.kqlQuery && timeline.kqlQuery.filterQuery && timeline.kqlQuery.filterQuery.kuery ? timeline.kqlQuery.filterQuery.kuery.expression : null);
exports.getKqlFilterQuerySelector = getKqlFilterQuerySelector;
const getKqlFilterKuerySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline && timeline.kqlQuery && timeline.kqlQuery.filterQuery && timeline.kqlQuery.filterQuery.kuery ? timeline.kqlQuery.filterQuery.kuery : null);
exports.getKqlFilterKuerySelector = getKqlFilterKuerySelector;
const dataProviderVisibilitySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline.isDataProviderVisible);
exports.dataProviderVisibilitySelector = dataProviderVisibilitySelector;