"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimelineEpic = exports.convertTimelineAsInput = void 0;
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _operators = require("rxjs/operators");
var _timeline = require("../../../../common/api/timeline");
var _actions = require("../../../common/store/app/actions");
var _api = require("../../containers/api");
var _all = require("../../containers/all");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _actions2 = require("./actions");
var _epic_note = require("./epic_note");
var _epic_pinned_event = require("./epic_pinned_event");
var _epic_favorite = require("./epic_favorite");
var _helpers = require("./helpers");
var _epic_dispatcher_timeline_persistence_queue = require("./epic_dispatcher_timeline_persistence_queue");
var _my_epic_timeline_id = require("./my_epic_timeline_id");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isItAtimelineAction = timelineId => timelineId && timelineId.toLowerCase().startsWith('timeline');
const createTimelineEpic = () => (action$, state$, {
  selectAllTimelineQuery,
  selectNotesByIdSelector,
  timelineByIdSelector,
  timelineTimeRangeSelector,
  kibana$
}) => {
  const timeline$ = state$.pipe((0, _operators.map)(timelineByIdSelector), (0, _operators.filter)(_helpers.isNotNull));
  const allTimelineQuery$ = state$.pipe((0, _operators.map)(state => {
    const getQuery = selectAllTimelineQuery();
    return getQuery(state, _all.ALL_TIMELINE_QUERY_ID);
  }), (0, _operators.filter)(_helpers.isNotNull));
  const notes$ = state$.pipe((0, _operators.map)(selectNotesByIdSelector), (0, _operators.filter)(_helpers.isNotNull));
  const timelineTimeRange$ = state$.pipe((0, _operators.map)(timelineTimeRangeSelector), (0, _operators.filter)(_helpers.isNotNull));
  return (0, _rxjs.merge)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([action, timeline]) => {
    const timelineId = (0, _fp.get)('payload.id', action);
    const timelineObj = timeline[timelineId];
    if (action.type === _actions.addError.type) {
      return true;
    }
    if (isItAtimelineAction(timelineId) && timelineObj != null && timelineObj.status != null && _timeline.TimelineStatus.immutable === timelineObj.status) {
      return false;
    } else if (action.type === _actions2.createTimeline.type && isItAtimelineAction(timelineId)) {
      _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(null);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineId(null);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(null);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(null);
    } else if (action.type === _actions2.addTimeline.type && isItAtimelineAction(timelineId)) {
      const addNewTimeline = (0, _fp.get)('payload.timeline', action);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineId(addNewTimeline.savedObjectId);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(addNewTimeline.version);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(addNewTimeline.templateTimelineId);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(addNewTimeline.templateTimelineVersion);
      return (0, _fp.getOr)(false, 'payload.savedTimeline', action);
    } else if (action.type === _actions2.saveTimeline.type && !timelineObj.isSaving && isItAtimelineAction(timelineId)) {
      return true;
    }
  }), (0, _operators.mergeMap)(([action]) => {
    _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.next({
      action
    });
    return _rxjs.EMPTY;
  })), _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.pipe((0, _operators.withLatestFrom)(timeline$, notes$, timelineTimeRange$), (0, _operators.concatMap)(([objAction, timeline, notes, timelineTimeRange]) => {
    const action = (0, _fp.get)('action', objAction);
    const timelineId = _my_epic_timeline_id.myEpicTimelineId.getTimelineId();
    const version = _my_epic_timeline_id.myEpicTimelineId.getTimelineVersion();
    const templateTimelineId = _my_epic_timeline_id.myEpicTimelineId.getTemplateTimelineId();
    const templateTimelineVersion = _my_epic_timeline_id.myEpicTimelineId.getTemplateTimelineVersion();
    if ((0, _epic_note.isNoteAction)(action)) {
      return (0, _epic_note.epicPersistNote)(action, notes, action$, timeline$, notes$, allTimelineQuery$);
    } else if ((0, _epic_pinned_event.isPinnedEventAction)(action)) {
      return (0, _epic_pinned_event.epicPersistPinnedEvent)(action, timeline, action$, timeline$, allTimelineQuery$);
    } else if ((0, _epic_favorite.isFavoriteTimelineAction)(action)) {
      return (0, _epic_favorite.epicPersistTimelineFavorite)(action, timeline, action$, timeline$, allTimelineQuery$);
    } else if (isSaveTimelineAction(action)) {
      const saveAction = action;
      const savedSearch = timeline[action.payload.id].savedSearch;
      return (0, _rxjs.from)(saveAction.payload.saveAsNew && timelineId ? (0, _api.copyTimeline)({
        timelineId,
        timeline: {
          ...convertTimelineAsInput(timeline[action.payload.id], timelineTimeRange),
          templateTimelineId,
          templateTimelineVersion
        },
        savedSearch
      }) : (0, _api.persistTimeline)({
        timelineId,
        version,
        timeline: {
          ...convertTimelineAsInput(timeline[action.payload.id], timelineTimeRange),
          templateTimelineId,
          templateTimelineVersion
        },
        savedSearch
      })).pipe((0, _operators.withLatestFrom)(timeline$, allTimelineQuery$, kibana$), (0, _operators.mergeMap)(([response, recentTimeline, allTimelineQuery, kibana]) => {
        var _error$message, _unwrappedResponse$ti, _unwrappedResponse$ti2, _unwrappedResponse$ti3, _unwrappedResponse$ti4, _unwrappedResponse$ti5, _unwrappedResponse$ti6;
        if (isTimelineErrorResponse(response)) {
          const error = getErrorFromResponse(response);
          switch (error === null || error === void 0 ? void 0 : error.errorCode) {
            // conflict
            case 409:
              kibana.notifications.toasts.addDanger({
                title: i18n.TIMELINE_VERSION_CONFLICT_TITLE,
                text: i18n.TIMELINE_VERSION_CONFLICT_DESCRIPTION
              });
              break;
            default:
              kibana.notifications.toasts.addDanger({
                title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
                text: (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : i18n.UPDATE_TIMELINE_ERROR_TEXT
              });
          }
          return [(0, _actions2.endTimelineSaving)({
            id: action.payload.id
          })];
        }
        const unwrappedResponse = response.data.persistTimeline;
        if (unwrappedResponse == null) {
          kibana.notifications.toasts.addDanger({
            title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
            text: i18n.UPDATE_TIMELINE_ERROR_TEXT
          });
          return [(0, _actions2.endTimelineSaving)({
            id: action.payload.id
          })];
        }
        if (unwrappedResponse.code === 403) {
          return [(0, _actions2.showCallOutUnauthorizedMsg)(), (0, _actions2.endTimelineSaving)({
            id: action.payload.id
          })];
        }
        if (allTimelineQuery.refetch != null) {
          allTimelineQuery.refetch();
        }
        return [(0, _actions2.updateTimeline)({
          id: action.payload.id,
          timeline: {
            ...recentTimeline[action.payload.id],
            updated: (_unwrappedResponse$ti = unwrappedResponse.timeline.updated) !== null && _unwrappedResponse$ti !== void 0 ? _unwrappedResponse$ti : undefined,
            savedObjectId: unwrappedResponse.timeline.savedObjectId,
            version: unwrappedResponse.timeline.version,
            status: (_unwrappedResponse$ti2 = unwrappedResponse.timeline.status) !== null && _unwrappedResponse$ti2 !== void 0 ? _unwrappedResponse$ti2 : _timeline.TimelineStatus.active,
            timelineType: (_unwrappedResponse$ti3 = unwrappedResponse.timeline.timelineType) !== null && _unwrappedResponse$ti3 !== void 0 ? _unwrappedResponse$ti3 : _timeline.TimelineType.default,
            templateTimelineId: (_unwrappedResponse$ti4 = unwrappedResponse.timeline.templateTimelineId) !== null && _unwrappedResponse$ti4 !== void 0 ? _unwrappedResponse$ti4 : null,
            templateTimelineVersion: (_unwrappedResponse$ti5 = unwrappedResponse.timeline.templateTimelineVersion) !== null && _unwrappedResponse$ti5 !== void 0 ? _unwrappedResponse$ti5 : null,
            savedSearchId: (_unwrappedResponse$ti6 = unwrappedResponse.timeline.savedSearchId) !== null && _unwrappedResponse$ti6 !== void 0 ? _unwrappedResponse$ti6 : null,
            isSaving: false
          }
        }), (0, _actions2.setChanged)({
          id: action.payload.id,
          changed: false
        }), (0, _actions2.endTimelineSaving)({
          id: action.payload.id
        })];
      }), (0, _operators.startWith)((0, _actions2.startTimelineSaving)({
        id: action.payload.id
      })), (0, _operators.takeUntil)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([checkAction, updatedTimeline]) => {
        if (checkAction.type === _actions2.endTimelineSaving.type && updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId != null) {
          _my_epic_timeline_id.myEpicTimelineId.setTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId);
          _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].version);
          _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineId);
          _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineVersion);
          return true;
        }
        return false;
      }))));
    }
    return _rxjs.EMPTY;
  })));
};
exports.createTimelineEpic = createTimelineEpic;
function isSaveTimelineAction(action) {
  return action.type === _actions2.saveTimeline.type;
}
const timelineInput = {
  columns: null,
  dataProviders: null,
  dataViewId: null,
  description: null,
  eqlOptions: null,
  eventType: null,
  excludedRowRendererIds: null,
  filters: null,
  kqlMode: null,
  kqlQuery: null,
  indexNames: null,
  title: null,
  timelineType: _timeline.TimelineType.default,
  templateTimelineVersion: null,
  templateTimelineId: null,
  dateRange: null,
  savedQueryId: null,
  sort: null,
  status: null,
  savedSearchId: null
};
const convertTimelineAsInput = (timeline, timelineTimeRange) => Object.keys(timelineInput).reduce((acc, key) => {
  if ((0, _fp.has)(key, timeline)) {
    if (key === 'kqlQuery') {
      return (0, _fp.set)(`${key}.filterQuery`, (0, _fp.get)(`${key}.filterQuery`, timeline), acc);
    } else if (key === 'dateRange') {
      return (0, _fp.set)(`${key}`, {
        start: timelineTimeRange.from,
        end: timelineTimeRange.to
      }, acc);
    } else if (key === 'columns' && (0, _fp.get)(key, timeline) != null) {
      return (0, _fp.set)(key, (0, _fp.get)(key, timeline).map(col => (0, _fp.omit)(['initialWidth', 'width', '__typename', 'esTypes'], col)), acc);
    } else if (key === 'filters' && (0, _fp.get)(key, timeline) != null) {
      const filters = (0, _fp.get)(key, timeline);
      return (0, _fp.set)(key, filters != null ? filters.map(myFilter => {
        const basicFilter = (0, _fp.omit)(['$state'], myFilter);
        return {
          ...basicFilter,
          meta: {
            ...basicFilter.meta,
            field: ((0, _esQuery.isMatchAllFilter)(basicFilter) || (0, _esQuery.isPhraseFilter)(basicFilter) || (0, _esQuery.isPhrasesFilter)(basicFilter) || (0, _esQuery.isRangeFilter)(basicFilter)) && basicFilter.meta.field != null ? convertToString(basicFilter.meta.field) : null,
            value: basicFilter.meta.value != null ? convertToString(basicFilter.meta.value) : null,
            params: basicFilter.meta.params != null ? convertToString(basicFilter.meta.params) : null
          },
          ...((0, _esQuery.isMatchAllFilter)(basicFilter) ? {
            query: {
              match_all: convertToString(basicFilter.query.match_all)
            }
          } : {
            match_all: null
          }),
          ...((0, _esQuery.isExistsFilter)(basicFilter) && basicFilter.query.exists != null ? {
            query: {
              exists: convertToString(basicFilter.query.exists)
            }
          } : {
            exists: null
          }),
          ...(((0, _esQuery.isQueryStringFilter)(basicFilter) || (0, _fp.get)('query', basicFilter) != null) && basicFilter.query != null ? {
            query: convertToString(basicFilter.query)
          } : {
            query: null
          }),
          ...((0, _esQuery.isRangeFilter)(basicFilter) && basicFilter.query.range != null ? {
            query: {
              range: convertToString(basicFilter.query.range)
            }
          } : {
            range: null
          }),
          ...((0, _esQuery.isScriptedRangeFilter)(basicFilter) && basicFilter.query.script != null /* TODO remove it when PR50713 is merged || esFilters.isPhraseFilter(basicFilter) */ ? {
            query: {
              script: convertToString(basicFilter.query.script)
            }
          } : {
            script: null
          })
        };
      }) : [], acc);
    }
    return (0, _fp.set)(key, (0, _fp.get)(key, timeline), acc);
  }
  return acc;
}, timelineInput);
exports.convertTimelineAsInput = convertTimelineAsInput;
const convertToString = obj => {
  try {
    if ((0, _fp.isObject)(obj)) {
      return JSON.stringify(obj);
    }
    return (0, _fp.toString)(obj);
  } catch {
    return '';
  }
};
function isTimelineErrorResponse(response) {
  return 'status_code' in response || 'statusCode' in response;
}
function getErrorFromResponse(response) {
  if ('status_code' in response) {
    return {
      errorCode: response.status_code,
      message: response.message
    };
  } else if ('statusCode' in response) {
    return {
      errorCode: response.statusCode,
      message: response.message
    };
  }
}