"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineKpis = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/timelines-plugin/common");
var _kibana = require("../../../common/lib/kibana");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineKpis = ({
  timerange,
  filterQuery,
  defaultIndex,
  isBlankTimeline
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(false);
  const [timelineKpiRequest, setTimelineKpiRequest] = (0, _react.useState)(null);
  const [timelineKpiResponse, setTimelineKpiResponse] = (0, _react.useState)(null);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const timelineKpiSearch = (0, _react.useCallback)(request => {
    if (request == null) {
      return;
    }
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      searchSubscription$.current = data.search.search(request, {
        strategy: 'timelineSearchStrategy',
        abortSignal: abortCtrl.current.signal
      }).subscribe({
        next: response => {
          if (!(0, _public.isRunningResponse)(response)) {
            setLoading(false);
            setTimelineKpiResponse(response);
            searchSubscription$.current.unsubscribe();
          }
        },
        error: msg => {
          setLoading(false);
          addError(msg, {
            title: i18n.FAIL_TIMELINE_KPI_SEARCH_DETAILS
          });
          searchSubscription$.current.unsubscribe();
        }
      });
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, addError]);
  (0, _react.useEffect)(() => {
    setTimelineKpiRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex,
        timerange,
        filterQuery,
        factoryQueryType: _common.TimelineEventsQueries.kpi
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [defaultIndex, timerange, filterQuery]);
  (0, _react.useEffect)(() => {
    if (!isBlankTimeline) {
      timelineKpiSearch(timelineKpiRequest);
    } else {
      setLoading(false);
      setTimelineKpiResponse(null);
    }
    return () => {
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    };
  }, [isBlankTimeline, timelineKpiRequest, timelineKpiSearch]);
  return [loading, timelineKpiResponse];
};
exports.useTimelineKpis = useTimelineKpis;