"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineDatePickerLock = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _constants = require("../../../../common/store/inputs/constants");
var _inputs = require("../../../../common/store/inputs");
var _use_selector = require("../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineDatePickerLockComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalInput = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalSelector(), []);
  const isDatePickerLocked = (0, _use_selector.useShallowEqualSelector)(state => getGlobalInput(state).linkTo.includes(_constants.InputsModelId.timeline));
  const onToggleLock = (0, _react.useCallback)(() => dispatch(_inputs.inputsActions.toggleTimelineLinkTo()), [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "timeline-date-picker-lock-tooltip",
    position: "top",
    content: isDatePickerLocked ? i18n.LOCK_SYNC_MAIN_DATE_PICKER_TOOL_TIP : i18n.UNLOCK_SYNC_MAIN_DATE_PICKER_TOOL_TIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `timeline-date-picker-${isDatePickerLocked ? 'lock' : 'unlock'}-button`,
    color: "primary",
    size: "m",
    onClick: onToggleLock,
    iconType: isDatePickerLocked ? 'lock' : 'lockOpen',
    display: isDatePickerLocked ? 'fill' : 'base',
    "aria-label": isDatePickerLocked ? i18n.UNLOCK_SYNC_MAIN_DATE_PICKER_ARIA : i18n.LOCK_SYNC_MAIN_DATE_PICKER_ARIA
  }));
};
TimelineDatePickerLockComponent.displayName = 'TimelineDatePickerLockComponent';
const TimelineDatePickerLock = /*#__PURE__*/_react.default.memo(TimelineDatePickerLockComponent);
exports.TimelineDatePickerLock = TimelineDatePickerLock;