"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.twoGroups = exports.providerF = exports.providerE = exports.providerD = exports.providerC = exports.providerB = exports.providerA = void 0;
var _data_provider = require("../data_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const providerA = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-a',
  kqlQuery: '',
  name: 'a',
  queryMatch: {
    field: 'field.name',
    value: 'a',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerA = providerA;
const providerB = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-b',
  kqlQuery: '',
  name: 'b',
  queryMatch: {
    field: 'field.name',
    value: 'b',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerB = providerB;
const providerC = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-c',
  kqlQuery: '',
  name: 'c',
  queryMatch: {
    field: 'field.name',
    value: 'c',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerC = providerC;
const providerD = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-d',
  kqlQuery: '',
  name: 'd',
  queryMatch: {
    field: 'field.name',
    value: 'd',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerD = providerD;
const providerE = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-e',
  kqlQuery: '',
  name: 'e',
  queryMatch: {
    field: 'field.name',
    value: 'e',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerE = providerE;
const providerF = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-f',
  kqlQuery: '',
  name: 'f',
  queryMatch: {
    field: 'field.name',
    value: 'f',
    operator: _data_provider.IS_OPERATOR
  }
};
exports.providerF = providerF;
const twoGroups = [{
  ...providerA,
  and: [providerB, providerC]
}, {
  ...providerD,
  and: [providerE, providerF]
}];
exports.twoGroups = twoGroups;