"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unFlattenGroups = exports.sourceAndDestinationAreSameDroppable = exports.reorder = exports.reArrangeProvidersInSameGroup = exports.reArrangeProviders = exports.omitAnd = exports.moveProvidersBetweenGroups = exports.move = exports.isValidDestination = exports.indexIsValid = exports.getGroupIndexFromDroppableId = exports.getDisplayValue = exports.flattenIntoAndGroups = exports.convertDataProviderAnd = exports.addProviderToGroup = exports.addProviderToEmptyTimeline = exports.addContentToTimeline = exports.EMPTY_GROUP = void 0;
var _fp = require("lodash/fp");
var _actions = require("../../../store/timeline/actions");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const omitAnd = provider => (0, _fp.omit)('and', provider);
exports.omitAnd = omitAnd;
const reorder = ({
  endIndex,
  group,
  startIndex
}) => {
  const groupClone = [...group];
  const [removed] = groupClone.splice(startIndex, 1); // ⚠️ mutation
  groupClone.splice(endIndex, 0, removed); // ⚠️ mutation

  return groupClone;
};
exports.reorder = reorder;
const move = ({
  destinationGroup,
  moveProviderFromSourceIndex,
  moveProviderToDestinationIndex,
  sourceGroup
}) => {
  const sourceClone = [...sourceGroup];
  const destinationClone = [...destinationGroup];
  const [removed] = sourceClone.splice(moveProviderFromSourceIndex, 1); // ⚠️ mutation
  destinationClone.splice(moveProviderToDestinationIndex, 0, removed); // ⚠️ mutation

  const deDuplicatedDestinationGroup = destinationClone.filter((provider, i) => provider.id === removed.id && i !== moveProviderToDestinationIndex ? false : true);
  return {
    updatedDestinationGroup: deDuplicatedDestinationGroup,
    updatedSourcererScope: sourceClone
  };
};
exports.move = move;
const isValidDestination = destination => destination != null;
exports.isValidDestination = isValidDestination;
const sourceAndDestinationAreSameDroppable = ({
  destination,
  source
}) => source.droppableId === destination.droppableId;
exports.sourceAndDestinationAreSameDroppable = sourceAndDestinationAreSameDroppable;
const flattenIntoAndGroups = dataProviders => dataProviders.reduce((acc, provider) => [...acc, [omitAnd(provider), ...provider.and]], []);
exports.flattenIntoAndGroups = flattenIntoAndGroups;
const reArrangeProvidersInSameGroup = ({
  dataProviderGroups,
  destination,
  dispatch,
  source,
  timelineId
}) => {
  const groupIndex = getGroupIndexFromDroppableId(source.droppableId);
  if (indexIsValid({
    index: groupIndex,
    dataProviderGroups
  })) {
    const reorderedGroup = reorder({
      group: dataProviderGroups[groupIndex],
      startIndex: source.index,
      endIndex: destination.index
    });
    const updatedGroups = dataProviderGroups.reduce((acc, group, i) => [...acc, i === groupIndex ? [...reorderedGroup] : [...group]], []);
    dispatch((0, _actions.updateProviders)({
      id: timelineId,
      providers: unFlattenGroups(updatedGroups.filter(g => g.length))
    }));
  }
};
exports.reArrangeProvidersInSameGroup = reArrangeProvidersInSameGroup;
const getGroupIndexFromDroppableId = droppableId => Number(droppableId.substring(droppableId.lastIndexOf('.') + 1));
exports.getGroupIndexFromDroppableId = getGroupIndexFromDroppableId;
const indexIsValid = ({
  index,
  dataProviderGroups
}) => index >= 0 && index < dataProviderGroups.length;
exports.indexIsValid = indexIsValid;
const convertDataProviderAnd = dataProvidersAnd => ({
  ...dataProvidersAnd,
  and: []
});
exports.convertDataProviderAnd = convertDataProviderAnd;
const unFlattenGroups = groups => groups.reduce((acc, group) => [...acc, {
  ...group[0],
  and: group.slice(1)
}], []);
exports.unFlattenGroups = unFlattenGroups;
const moveProvidersBetweenGroups = ({
  dataProviderGroups,
  destination,
  dispatch,
  source,
  timelineId
}) => {
  const sourceGroupIndex = getGroupIndexFromDroppableId(source.droppableId);
  const destinationGroupIndex = getGroupIndexFromDroppableId(destination.droppableId);
  if (indexIsValid({
    index: sourceGroupIndex,
    dataProviderGroups
  }) && indexIsValid({
    index: destinationGroupIndex,
    dataProviderGroups
  })) {
    const sourceGroup = dataProviderGroups[sourceGroupIndex];
    const destinationGroup = dataProviderGroups[destinationGroupIndex];
    const moveProviderFromSourceIndex = source.index;
    const moveProviderToDestinationIndex = destination.index;
    const {
      updatedDestinationGroup,
      updatedSourcererScope
    } = move({
      destinationGroup,
      moveProviderFromSourceIndex,
      moveProviderToDestinationIndex,
      sourceGroup
    });
    const updatedGroups = dataProviderGroups.reduce((acc, group, i) => [...acc, i === sourceGroupIndex ? [...updatedSourcererScope] : i === destinationGroupIndex ? [...updatedDestinationGroup] : [...group]], []);
    dispatch((0, _actions.updateProviders)({
      id: timelineId,
      providers: unFlattenGroups(updatedGroups.filter(g => g.length))
    }));
  }
};
exports.moveProvidersBetweenGroups = moveProvidersBetweenGroups;
const addProviderToEmptyTimeline = ({
  dispatch,
  onAddedToTimeline,
  providerToAdd,
  timelineId
}) => {
  dispatch((0, _actions.updateProviders)({
    id: timelineId,
    providers: [providerToAdd]
  }));
  onAddedToTimeline(providerToAdd.name);
};

/** Rendered as a constant drop target for creating a new OR group */
exports.addProviderToEmptyTimeline = addProviderToEmptyTimeline;
const EMPTY_GROUP = [[]];
exports.EMPTY_GROUP = EMPTY_GROUP;
const reArrangeProviders = ({
  dataProviders,
  destination,
  dispatch,
  source,
  timelineId
}) => {
  if (!isValidDestination(destination)) {
    return;
  }
  const dataProviderGroups = [...flattenIntoAndGroups(dataProviders), ...EMPTY_GROUP];
  if (sourceAndDestinationAreSameDroppable({
    source,
    destination
  })) {
    reArrangeProvidersInSameGroup({
      dataProviderGroups,
      destination,
      dispatch,
      source,
      timelineId
    });
  } else {
    moveProvidersBetweenGroups({
      dataProviderGroups,
      destination,
      dispatch,
      source,
      timelineId
    });
  }
};
exports.reArrangeProviders = reArrangeProviders;
const addProviderToGroup = ({
  dataProviders,
  destination,
  dispatch,
  onAddedToTimeline,
  providerToAdd,
  timelineId
}) => {
  const dataProviderGroups = [...flattenIntoAndGroups(dataProviders), ...EMPTY_GROUP];
  if (!isValidDestination(destination)) {
    return;
  }
  const destinationGroupIndex = getGroupIndexFromDroppableId(destination.droppableId);
  if (indexIsValid({
    index: destinationGroupIndex,
    dataProviderGroups
  })) {
    const destinationGroup = dataProviderGroups[destinationGroupIndex];
    const destinationClone = [...destinationGroup];
    destinationClone.splice(destination.index, 0, omitAnd(providerToAdd)); // ⚠️ mutation
    const deDuplicatedGroup = destinationClone.filter((provider, i) => provider.id === providerToAdd.id && i !== destination.index ? false : true);
    const updatedGroups = dataProviderGroups.reduce((acc, group, i) => [...acc, i === destinationGroupIndex ? [...deDuplicatedGroup] : [...group]], []);
    dispatch((0, _actions.updateProviders)({
      id: timelineId,
      providers: unFlattenGroups(updatedGroups.filter(g => g.length))
    }));
    onAddedToTimeline(providerToAdd.name);
  }
};
exports.addProviderToGroup = addProviderToGroup;
const addContentToTimeline = ({
  dataProviders,
  destination,
  dispatch,
  onAddedToTimeline,
  providerToAdd,
  timelineId
}) => {
  if (dataProviders.length === 0) {
    addProviderToEmptyTimeline({
      dispatch,
      onAddedToTimeline,
      providerToAdd,
      timelineId
    });
  } else {
    addProviderToGroup({
      dataProviders,
      destination,
      dispatch,
      onAddedToTimeline,
      providerToAdd,
      timelineId
    });
  }
};
exports.addContentToTimeline = addContentToTimeline;
const getDisplayValue = value => {
  if ((0, _helpers.isPrimitiveArray)(value)) {
    if (value.length) {
      return `( ${value.join(' OR ')} )`;
    }
    return '';
  }
  return value;
};
exports.getDisplayValue = getDisplayValue;