"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataProviderPopover = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _edit_data_provider = require("../../edit_data_provider");
var _helpers = require("./helpers");
var _data_provider = require("./data_provider");
var _timeline2 = require("../../../store/timeline");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddFieldPopoverContainer = _styledComponents.default.div`
  min-width: 350px;
`;
const AddDataProviderPopoverComponent = ({
  browserFields,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isAddFilterPopoverOpen, setIsAddFilterPopoverOpen] = (0, _react.useState)(false);
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    dataProviders,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['dataProviders', 'timelineType'], getTimeline(state, timelineId)));
  const togglePopoverState = (0, _react.useCallback)(() => setIsAddFilterPopoverOpen(!isAddFilterPopoverOpen), [setIsAddFilterPopoverOpen, isAddFilterPopoverOpen]);
  const handleClosePopover = (0, _react.useCallback)(() => setIsAddFilterPopoverOpen(false), [setIsAddFilterPopoverOpen]);
  const handleDataProviderEdited = (0, _react.useCallback)(({
    andProviderId,
    excluded,
    field,
    id,
    operator,
    providerId,
    value,
    type
  }) => {
    (0, _helpers.addContentToTimeline)({
      dataProviders,
      destination: {
        droppableId: `droppableId.timelineProviders.${timelineId}.group.${dataProviders.length}`,
        index: 0
      },
      dispatch,
      onAddedToTimeline: handleClosePopover,
      providerToAdd: {
        id: providerId,
        name: field,
        enabled: true,
        excluded,
        kqlQuery: '',
        type,
        queryMatch: {
          displayField: undefined,
          displayValue: (0, _helpers.getDisplayValue)(value),
          field,
          value,
          operator
        },
        and: []
      },
      timelineId
    });
  }, [dataProviders, timelineId, dispatch, handleClosePopover]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    width: 400,
    items: [{
      name: _translations.ADD_FIELD_LABEL,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "plusInCircle",
        size: "m"
      }),
      panel: 1
    }, timelineType === _timeline.TimelineType.template ? {
      disabled: timelineType !== _timeline.TimelineType.template,
      name: _translations.ADD_TEMPLATE_FIELD_LABEL,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "visText",
        size: "m"
      }),
      panel: 2
    } : null].filter(item => item !== null)
  }, {
    id: 1,
    title: _translations.ADD_FIELD_LABEL,
    width: 400,
    content: /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _data_provider.DataProviderType.default,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`
    })
  }, {
    id: 2,
    title: _translations.ADD_TEMPLATE_FIELD_LABEL,
    width: 400,
    content: /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _data_provider.DataProviderType.template,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`
    })
  }], [browserFields, handleDataProviderEdited, timelineId, timelineType]);
  const button = (0, _react.useMemo)(() => {
    if (timelineType === _timeline.TimelineType.template) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        onClick: togglePopoverState,
        "data-test-subj": "addField",
        iconType: "arrowDown",
        fill: true,
        iconSide: "right"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _translations.ADD_FIELD_LABEL));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: togglePopoverState,
      "data-test-subj": "addField",
      iconSide: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, `+ ${_translations.ADD_FIELD_LABEL}`));
  }, [togglePopoverState, timelineType]);
  const content = (0, _react.useMemo)(() => {
    if (timelineType === _timeline.TimelineType.template) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
        initialPanelId: 0,
        panels: panels
      });
    }
    return /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _data_provider.DataProviderType.default,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`
    });
  }, [browserFields, handleDataProviderEdited, panels, timelineId, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addFieldsPopover",
    button: button,
    isOpen: isAddFilterPopoverOpen,
    closePopover: handleClosePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(AddFieldPopoverContainer, null, content));
};
AddDataProviderPopoverComponent.displayName = 'AddDataProviderPopoverComponent';
const AddDataProviderPopover = /*#__PURE__*/_react.default.memo(AddDataProviderPopoverComponent);
exports.AddDataProviderPopover = AddDataProviderPopover;
AddDataProviderPopover.displayName = 'AddDataProviderPopover';