"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _user_right = require("../../../../../flyout/entity_details/user_right");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _helpers = require("../../../../../helpers");
var _timeline = require("../../../../../../common/types/timeline");
var _draggables = require("../../../../../common/components/draggables");
var _empty_value = require("../../../../../common/components/empty_value");
var _links = require("../../../../../common/components/links");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _active_timeline_context = require("../../../../containers/active_timeline_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserNameComponent = ({
  fieldName,
  Component,
  contextId,
  eventId,
  fieldType,
  isAggregatable,
  isDraggable,
  isButton,
  onClick,
  title,
  value
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const isNewUserDetailsFlyoutEnable = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyout');
  const userName = `${value}`;
  const isInTimelineContext = userName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const openUserDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }
    if (eventContext && isInTimelineContext) {
      const {
        timelineID,
        tabType
      } = eventContext;
      if (isNewUserDetailsFlyoutEnable && !(0, _helpers.isTimelineScope)(timelineID)) {
        openRightPanel({
          id: _user_right.UserPanelKey,
          params: {
            userName,
            contextID: contextId,
            scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
            isDraggable
          }
        });
      } else {
        const updatedExpandedDetail = {
          panelView: 'userDetail',
          params: {
            userName
          }
        };
        const scopedActions = (0, _helpers.getScopedActions)(timelineID);
        if (scopedActions) {
          dispatch(scopedActions.toggleDetailPanel({
            ...updatedExpandedDetail,
            id: timelineID,
            tabType: tabType
          }));
        }
        if (timelineID === _timeline.TimelineId.active && tabType === _timeline.TimelineTabs.query) {
          _active_timeline_context.activeTimeline.toggleExpandedDetail({
            ...updatedExpandedDetail
          });
        }
      }
    }
  }, [onClick, eventContext, isNewUserDetailsFlyoutEnable, isInTimelineContext, openRightPanel, userName, contextId, isDraggable, dispatch]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the User Details page
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
    Component: Component,
    userName: userName,
    isButton: isButton,
    onClick: isInTimelineContext ? openUserDetailsSidePanel : undefined,
    title: title
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content"
  }, userName)), [userName, isButton, isInTimelineContext, openUserDetailsSidePanel, Component, title]);
  return (0, _fp.isString)(value) && userName.length > 0 ? isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    isDraggable: isDraggable,
    tooltipContent: fieldName,
    value: userName
  }, content) : content : (0, _empty_value.getEmptyTagValue)();
};
const UserName = /*#__PURE__*/_react.default.memo(UserNameComponent);
exports.UserName = UserName;
UserName.displayName = 'UserName';