"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemGenericLine = exports.SystemGenericDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../../../../../../common/components/tables/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _netflow = require("../netflow");
var _user_host_working_dir = require("../user_host_working_dir");
var _helpers2 = require("../helpers");
var _process_draggable = require("../process_draggable");
var _package = require("./package");
var _auth_ssh = require("./auth_ssh");
var _page = require("../../../../../../common/components/page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SystemGenericLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  hostName,
  id,
  isDraggable,
  message,
  outcome,
  packageName,
  packageSummary,
  packageVersion,
  processPid,
  processName,
  processExecutable,
  sshSignature,
  sshMethod,
  text,
  userDomain,
  userName,
  workingDirectory
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
  contextId: contextId,
  eventId: id,
  hostName: hostName,
  isDraggable: isDraggable,
  userDomain: userDomain,
  userName: userName,
  workingDirectory: workingDirectory
}), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span"
}, text), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggable, {
  contextId: contextId,
  endgamePid: undefined,
  endgameProcessName: undefined,
  eventId: id,
  isDraggable: isDraggable,
  processPid: processPid,
  processName: processName,
  processExecutable: processExecutable
})), outcome != null && /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span"
}, i18n.WITH_RESULT), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: id,
  field: "event.outcome",
  isDraggable: isDraggable,
  queryValue: outcome,
  value: outcome,
  isAggregatable: true,
  fieldType: "keyword"
})), /*#__PURE__*/_react.default.createElement(_auth_ssh.AuthSsh, {
  contextId: contextId,
  eventId: id,
  isDraggable: isDraggable,
  sshSignature: sshSignature,
  sshMethod: sshMethod
}), /*#__PURE__*/_react.default.createElement(_package.Package, {
  contextId: contextId,
  eventId: id,
  isDraggable: isDraggable,
  packageName: packageName,
  packageSummary: packageSummary,
  packageVersion: packageVersion
})), message != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  gutterSize: "none",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_page.Badge, {
  iconType: "editorComment",
  color: "hollow",
  title: ""
}, /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
  value: message
})))))));
exports.SystemGenericLine = SystemGenericLine;
SystemGenericLine.displayName = 'SystemGenericLine';
const SystemGenericDetails = /*#__PURE__*/_react.default.memo(({
  contextId,
  data,
  isDraggable,
  text,
  timelineId
}) => {
  const id = data._id;
  const message = data.message != null ? data.message[0] : null;
  const hostName = (0, _fp.get)('host.name[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const outcome = (0, _fp.get)('event.outcome[0]', data);
  const packageName = (0, _fp.get)('system.audit.package.name[0]', data);
  const packageSummary = (0, _fp.get)('system.audit.package.summary[0]', data);
  const packageVersion = (0, _fp.get)('system.audit.package.version[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const sshSignature = (0, _fp.get)('system.auth.ssh.signature[0]', data);
  const sshMethod = (0, _fp.get)('system.auth.ssh.method[0]', data);
  const workingDirectory = (0, _fp.get)('process.working_directory[0]', data);
  return /*#__PURE__*/_react.default.createElement(_helpers2.Details, null, /*#__PURE__*/_react.default.createElement(SystemGenericLine, {
    contextId: contextId,
    hostName: hostName,
    id: id,
    isDraggable: isDraggable,
    message: message,
    outcome: outcome,
    packageName: packageName,
    packageSummary: packageSummary,
    packageVersion: packageVersion,
    processExecutable: processExecutable,
    processPid: processPid,
    processName: processName,
    sshMethod: sshMethod,
    sshSignature: sshSignature,
    text: text,
    userDomain: userDomain,
    userName: userName,
    workingDirectory: workingDirectory
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
    data: data,
    isDraggable: isDraggable,
    timelineId: timelineId
  }));
});
exports.SystemGenericDetails = SystemGenericDetails;
SystemGenericDetails.displayName = 'SystemGenericDetails';