"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatefulCellComponent = ({
  rowIndex,
  colIndex,
  data,
  header,
  eventId,
  linkValues,
  renderCellValue,
  tabType,
  timelineId
}) => {
  const [cellProps, setCellProps] = (0, _react.useState)({});
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    "data-test-subj": "statefulCell"
  }, cellProps), renderCellValue({
    columnId: header.id,
    eventId,
    data,
    header,
    isDraggable: true,
    isExpandable: true,
    isExpanded: false,
    isDetails: false,
    isTimeline: true,
    linkValues,
    rowIndex,
    colIndex,
    setCellProps,
    scopeId: timelineId,
    key: tabType != null ? `${timelineId}-${tabType}` : timelineId
  }));
};
StatefulCellComponent.displayName = 'StatefulCellComponent';
const StatefulCell = /*#__PURE__*/_react.default.memo(StatefulCellComponent);
exports.StatefulCell = StatefulCell;