"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangePickerWidth = exports.RangePicker = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _ranges = require("./ranges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rangePickerWidth = 120;

// TODO: Upgrade Eui library and use EuiSuperSelect
exports.rangePickerWidth = rangePickerWidth;
const SelectContainer = _styledComponents.default.div`
  cursor: pointer;
  width: ${rangePickerWidth}px;
`;
SelectContainer.displayName = 'SelectContainer';

/** Renders a time range picker for the MiniMap (e.g. 1 Day, 1 Week...) */
const RangePicker = /*#__PURE__*/_react.default.memo(({
  selected,
  onRangeSelected
}) => {
  const onChange = event => {
    onRangeSelected(event.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(SelectContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "rangePicker",
    value: selected,
    options: _ranges.Ranges.map(range => ({
      text: range
    })),
    onChange: onChange
  }));
});
exports.RangePicker = RangePicker;
RangePicker.displayName = 'RangePicker';