"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderContent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _truncatable_text = require("../../../../../../common/components/truncatable_text");
var _styles = require("../../../styles");
var _sort_indicator = require("../../sort/sort_indicator");
var _header_tooltip_content = require("../header_tooltip_content");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderContentComponent = ({
  children,
  header,
  isLoading,
  isResizing,
  onClick,
  showSortingCapability,
  sort
}) => {
  var _header$displayAsText, _header$displayAsText2;
  return /*#__PURE__*/_react.default.createElement(_styles.EventsHeading, {
    "data-test-subj": `header-${header.id}`,
    isLoading: isLoading
  }, header.aggregatable && showSortingCapability ? /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingTitleButton, {
    "data-test-subj": "header-sort-button",
    onClick: !isResizing && !isLoading ? onClick : _fp.noop
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": `header-text-${header.id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "header-tooltip",
    content: /*#__PURE__*/_react.default.createElement(_header_tooltip_content.HeaderToolTipContent, {
      header: header
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.isValidElement(header.display) ? header.display : (_header$displayAsText = header.displayAsText) !== null && _header$displayAsText !== void 0 ? _header$displayAsText : header.id))), /*#__PURE__*/_react.default.createElement(_sort_indicator.SortIndicator, {
    "data-test-subj": "header-sort-indicator",
    sortDirection: (0, _helpers.getSortDirection)({
      header,
      sort
    }),
    sortNumber: (0, _helpers.getSortIndex)({
      header,
      sort
    })
  })) : /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingTitleSpan, null, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": `header-text-${header.id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "header-tooltip",
    content: /*#__PURE__*/_react.default.createElement(_header_tooltip_content.HeaderToolTipContent, {
      header: header
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.isValidElement(header.display) ? header.display : (_header$displayAsText2 = header.displayAsText) !== null && _header$displayAsText2 !== void 0 ? _header$displayAsText2 : header.id)))), children);
};
const HeaderContent = /*#__PURE__*/_react.default.memo(HeaderContentComponent);
exports.HeaderContent = HeaderContent;