"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetailsFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _expandable_user = require("./expandable_user");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflow {
    display: flex;
    flex: 1;
    overflow-x: hidden;
    overflow-y: scroll;

    .euiFlyoutBody__overflowContent {
      flex: 1;
      overflow-x: hidden;
      overflow-y: scroll;
      padding: ${({
  theme
}) => `${theme.eui.euiSizeXS} ${theme.eui.euiSizeM} 64px`};
    }
  }
`;
const UserDetailsFlyout = ({
  contextID,
  scopeId,
  userName
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetailsTitle, {
  userName: userName
})), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetailsPageLink, {
  userName: userName
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetails, {
  contextID: contextID,
  scopeId: scopeId,
  userName: userName
})));
exports.UserDetailsFlyout = UserDetailsFlyout;