"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedUserAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _expandable_panel = require("../../../../flyout/shared/components/expandable_panel");
var _formatted_date = require("../../../../common/components/formatted_date");
var _constants = require("./constants");
var _asset_document_left = require("../../../../flyout/entity_details/asset_document_left");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedUserAccordion = ({
  children,
  title,
  managedUser,
  indexName,
  eventId,
  tableType
}) => {
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  const timestamp = (0, _fp.get)('@timestamp[0]', managedUser);
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const toggleDetails = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _asset_document_left.AssetDocumentLeftPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId: tableType
      }
    });
  }, [openLeftPanel, eventId, indexName, tableType]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title,
      iconType: 'arrowStart',
      headerContent: timestamp && /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
              font-size: ${xsFontSize};
            `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.timeline.userDetails.updatedTime",
        defaultMessage: "Updated {time}",
        values: {
          time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: timestamp,
            dateFormat: "MMM D, YYYY",
            relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS
          })
        }
      })),
      link: {
        callback: toggleDetails,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.showAssetDocument",
          defaultMessage: "Show asset details"
        })
      }
    },
    expand: {
      expandable: false
    }
  }, children);
};
exports.ManagedUserAccordion = ManagedUserAccordion;