"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableHostDetailsTitle = exports.ExpandableHostDetailsPageLink = exports.ExpandableHostDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _constants = require("../../../../common/store/inputs/constants");
var _links = require("../../../../common/components/links");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _host_overview = require("../../../../overview/components/host_overview");
var _actions = require("../../../../common/store/inputs/actions");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _host_to_criteria = require("../../../../common/components/ml/criteria/host_to_criteria");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _details = require("../../../../explore/hosts/containers/hosts/details");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledTitle = _styledComponents.default.h4`
  word-break: break-all;
  word-wrap: break-word;
  white-space: pre-wrap;
`;
const ExpandableHostDetailsTitle = ({
  hostName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(StyledTitle, null, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.hostDetails.title', {
  defaultMessage: 'Host details'
}), `: ${hostName}`));
exports.ExpandableHostDetailsTitle = ExpandableHostDetailsTitle;
const ExpandableHostDetailsPageLink = ({
  hostName
}) => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
  hostName: hostName,
  isButton: true
}, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.hostDetails.hostDetailsPageLink', {
  defaultMessage: 'View details page'
}));
exports.ExpandableHostDetailsPageLink = ExpandableHostDetailsPageLink;
const ExpandableHostDetails = ({
  contextID,
  scopeId,
  hostName,
  isDraggable = false
}) => {
  const {
    to,
    from,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  /*
    Normally `selectedPatterns` from useSourcererDataView would be where we obtain the indices,
    but those indices are only loaded when viewing the pages where the sourcerer is initialized (i.e. Hosts and Overview)
    When a user goes directly to the detections page, the patterns have not been loaded yet
    as that information isn't used for the detections page. With this details component being accessible
    from the detections page, the decision was made to get all existing index names to account for this.
    Otherwise, an empty array is defaulted for the `indexNames` in the query which leads to inconsistencies in the data returned
    (i.e. extraneous endpoint data is retrieved from the backend leading to endpoint data not being returned)
  */
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, {
    hostDetails: hostOverview
  }] = (0, _details.useHostDetails)({
    endDate: to,
    hostName,
    indexNames: selectedPatterns,
    startDate: from
  });
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(hostOverview),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(_host_overview.HostOverview, {
    contextID: contextID,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
    id: _details.ID,
    isInDetailsSidePanel: true,
    data: hostOverview,
    anomaliesData: anomaliesData,
    isDraggable: isDraggable,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    indexNames: selectedPatterns,
    loading: loading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    hostName: hostName,
    jobNameById: jobNameById
  }));
};
exports.ExpandableHostDetails = ExpandableHostDetails;