"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeaderContent = exports.FlyoutHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _sentinelone_alert_check = require("../../../../../common/utils/sentinelone_alert_check");
var _expandable_event = require("../expandable_event");
var _back_to_alert_details_link = require("./back_to_alert_details_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeaderContentComponent = ({
  eventId,
  eventIndex,
  isAlert,
  isHostIsolationPanelOpen,
  isolateAction,
  loading,
  promptContextId,
  ruleName,
  showAlertDetails,
  timestamp,
  scopeId,
  refetchFlyoutData,
  getFieldsData
}) => {
  const isSentinelOneAlert = (0, _react.useMemo)(() => {
    var _getFieldsData;
    return !!(isAlert && (_getFieldsData = getFieldsData(_sentinelone_alert_check.SENTINEL_ONE_AGENT_ID_FIELD)) !== null && _getFieldsData !== void 0 && _getFieldsData.length);
  }, [getFieldsData, isAlert]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isHostIsolationPanelOpen ? /*#__PURE__*/_react.default.createElement(_back_to_alert_details_link.BackToAlertDetailsLink, {
    isolateAction: isolateAction,
    showAlertDetails: showAlertDetails,
    showExperimentalBadge: isSentinelOneAlert
  }) : /*#__PURE__*/_react.default.createElement(_expandable_event.ExpandableEventTitle, {
    eventId: eventId,
    eventIndex: eventIndex,
    isAlert: isAlert,
    loading: loading,
    promptContextId: promptContextId,
    ruleName: ruleName,
    timestamp: timestamp,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData,
    getFieldsData: getFieldsData
  }));
};
const FlyoutHeaderContent = /*#__PURE__*/_react.default.memo(FlyoutHeaderContentComponent);
exports.FlyoutHeaderContent = FlyoutHeaderContent;
const FlyoutHeaderComponent = ({
  eventId,
  eventIndex,
  isAlert,
  isHostIsolationPanelOpen,
  isolateAction,
  loading,
  promptContextId,
  ruleName,
  showAlertDetails,
  timestamp,
  scopeId,
  refetchFlyoutData,
  getFieldsData
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: isHostIsolationPanelOpen
  }, /*#__PURE__*/_react.default.createElement(FlyoutHeaderContentComponent, {
    eventId: eventId,
    eventIndex: eventIndex,
    isAlert: isAlert,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isolateAction: isolateAction,
    loading: loading,
    promptContextId: promptContextId,
    ruleName: ruleName,
    showAlertDetails: showAlertDetails,
    timestamp: timestamp,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData,
    getFieldsData: getFieldsData
  }));
};
const FlyoutHeader = /*#__PURE__*/_react.default.memo(FlyoutHeaderComponent);
exports.FlyoutHeader = FlyoutHeader;