"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../timeline/body/renderers/system/translations");
var _generic_row_renderer = require("../../timeline/body/renderers/system/generic_row_renderer");
var _termination = require("../../../../common/demo_data/endgame_ecs/termination");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SystemExampleComponent = () => {
  const systemRowRenderer = (0, _generic_row_renderer.createGenericSystemRowRenderer)({
    actionName: 'termination_event',
    text: _translations.TERMINATED_PROCESS
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemRowRenderer.renderRow({
    data: _termination.demoEndgameTerminationEvent,
    isDraggable: false,
    scopeId: _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID
  }));
};
const SystemExample = /*#__PURE__*/_react.default.memo(SystemExampleComponent);
exports.SystemExample = SystemExample;