"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconHeaderColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the columns that have icon headers
 */
const getIconHeaderColumns = ({
  timelineType
}) => {
  const columns = {
    note: {
      align: 'center',
      field: 'eventIdToNoteIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.NOTES
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "data-test-subj": "notes-count-header-icon",
        size: "m",
        type: "editorComment"
      })),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "notes-count"
      }, (0, _helpers.getNotesCount)(timelineResult)),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    pinnedEvent: {
      align: 'center',
      field: 'pinnedEventIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.PINNED_EVENTS
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "data-test-subj": "pinned-event-header-icon",
        size: "m",
        type: "pin"
      })),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "pinned-event-count"
      }, `${(0, _helpers.getPinnedEventCount)(timelineResult)}`),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    favorite: {
      align: 'center',
      field: 'favorite',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.FAVORITES
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "data-test-subj": "favorites-header-icon",
        size: "m",
        type: "starEmpty"
      })),
      render: favorite => {
        const isFavorite = favorite != null && favorite.length > 0;
        const fill = isFavorite ? 'starFilled' : 'starEmpty';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "data-test-subj": `favorite-${fill}-star`,
          type: fill,
          size: "m"
        });
      },
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    }
  };
  const templateColumns = [columns.note, columns.favorite];
  const defaultColumns = [columns.pinnedEvent, columns.note, columns.favorite];
  return timelineType === _timeline.TimelineType.template ? templateColumns : defaultColumns;
};
exports.getIconHeaderColumns = getIconHeaderColumns;