"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../common/api/timeline");
var _import_data_modal = require("../../../common/components/import_data_modal");
var _utility_bar = require("../../../common/components/utility_bar");
var _api = require("../../containers/api");
var _user_privileges = require("../../../common/components/user_privileges");
var _edit_timeline_batch_actions = require("./edit_timeline_batch_actions");
var _edit_timeline_actions = require("./edit_timeline_actions");
var _export_timeline = require("./export_timeline");
var _search_row = require("./search_row");
var _timelines_table = require("./timelines_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryText = _styledComponents.default.span`
  white-space: normal;
  word-break: break-word;
`;
const OpenTimeline = /*#__PURE__*/_react.default.memo(({
  deleteTimelines,
  defaultPageSize,
  favoriteCount,
  isLoading,
  itemIdToExpandedNotesRowMap,
  importDataModalToggle,
  onCreateRule,
  onCreateRuleFromEql,
  onDeleteSelected,
  onlyFavorites,
  onOpenTimeline,
  onQueryChange,
  onSelectionChange,
  onTableChange,
  onToggleOnlyFavorites,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  query,
  refetch,
  searchResults,
  selectedItems,
  sortDirection,
  setImportDataModalToggle,
  sortField,
  timelineType = _timeline.TimelineType.default,
  timelineStatus,
  timelineFilter,
  templateTimelineFilter,
  totalSearchResultsCount
}) => {
  var _actionItem$title;
  const tableRef = (0, _react.useRef)();
  const {
    actionItem,
    enableExportTimelineDownloader,
    isEnableDownloader,
    isDeleteTimelineModalOpen,
    onOpenDeleteTimelineModal,
    onCompleteEditTimelineAction
  } = (0, _edit_timeline_actions.useEditTimelineActions)();
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    getBatchItemsPopoverContent
  } = (0, _edit_timeline_batch_actions.useEditTimelineBatchActions)({
    deleteTimelines: kibanaSecuritySolutionsPrivileges.crud ? deleteTimelines : undefined,
    selectedItems,
    tableRef,
    timelineType
  });
  const nTemplates = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.open.timeline.showingNTemplatesLabel",
    defaultMessage: "{totalSearchResultsCount} {totalSearchResultsCount, plural, one {template} other {templates}} {with}",
    values: {
      totalSearchResultsCount,
      with: /*#__PURE__*/_react.default.createElement(QueryText, {
        "data-test-subj": "selectable-query-text"
      }, query.trim().length ? `${i18n.WITH} "${query.trim()}"` : '')
    }
  }), [totalSearchResultsCount, query]);
  const nTimelines = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.open.timeline.showingNTimelinesLabel",
    defaultMessage: "{totalSearchResultsCount} {totalSearchResultsCount, plural, one {timeline} other {timelines}} {with}",
    values: {
      totalSearchResultsCount,
      with: /*#__PURE__*/_react.default.createElement(QueryText, {
        "data-test-subj": "selectable-query-text"
      }, query.trim().length ? `${i18n.WITH} "${query.trim()}"` : '')
    }
  }), [totalSearchResultsCount, query]);
  const actionItemId = (0, _react.useMemo)(() => actionItem != null && actionItem.savedObjectId != null ? [actionItem.savedObjectId] : [], [actionItem]);
  const actionItemSavedSearchId = (0, _react.useMemo)(() => {
    return actionItem != null && actionItem.savedSearchId != null ? [actionItem.savedSearchId] : undefined;
  }, [actionItem]);
  const onRefreshBtnClick = (0, _react.useCallback)(() => {
    if (refetch != null) {
      refetch();
    }
  }, [refetch]);
  const handleCloseModal = (0, _react.useCallback)(() => {
    if (setImportDataModalToggle != null) {
      setImportDataModalToggle(false);
    }
  }, [setImportDataModalToggle]);
  const handleComplete = (0, _react.useCallback)(() => {
    if (setImportDataModalToggle != null) {
      setImportDataModalToggle(false);
    }
    if (refetch != null) {
      refetch();
    }
  }, [setImportDataModalToggle, refetch]);
  const actionTimelineToShow = (0, _react.useMemo)(() => {
    if (kibanaSecuritySolutionsPrivileges.crud) {
      const createRule = ['createRule'];
      const createRuleFromEql = ['createRuleFromEql'];
      const timelineActions = ['createFrom', 'duplicate', ...(onCreateRule != null ? createRule : []), ...(onCreateRuleFromEql != null ? createRuleFromEql : [])];
      if (timelineStatus !== _timeline.TimelineStatus.immutable) {
        timelineActions.push('export');
        timelineActions.push('selectable');
      }
      if (onDeleteSelected != null && deleteTimelines != null && timelineStatus !== _timeline.TimelineStatus.immutable) {
        timelineActions.push('delete');
      }
      return timelineActions;
    }
    // user with read access should only see export
    if (timelineStatus !== _timeline.TimelineStatus.immutable) {
      return ['export', 'selectable'];
    }
    return [];
  }, [onCreateRule, onCreateRuleFromEql, timelineStatus, onDeleteSelected, deleteTimelines, kibanaSecuritySolutionsPrivileges]);
  const SearchRowContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, templateTimelineFilter), [templateTimelineFilter]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_export_timeline.EditTimelineActions, {
    deleteTimelines: deleteTimelines,
    ids: actionItemId,
    savedSearchIds: actionItemSavedSearchId,
    isDeleteTimelineModalOpen: isDeleteTimelineModalOpen,
    isEnableDownloader: isEnableDownloader,
    onComplete: onCompleteEditTimelineAction,
    title: (_actionItem$title = actionItem === null || actionItem === void 0 ? void 0 : actionItem.title) !== null && _actionItem$title !== void 0 ? _actionItem$title : i18n.UNTITLED_TIMELINE
  }), /*#__PURE__*/_react.default.createElement(_import_data_modal.ImportDataModal, {
    checkBoxLabel: i18n.OVERWRITE_WITH_SAME_NAME,
    closeModal: handleCloseModal,
    description: i18n.SELECT_TIMELINE,
    errorMessage: i18n.IMPORT_FAILED,
    failedDetailed: i18n.IMPORT_FAILED_DETAILED,
    importComplete: handleComplete,
    importData: _api.importTimelines,
    successMessage: i18n.SUCCESSFULLY_IMPORTED_TIMELINES,
    showCheckBox: false,
    showModal: importDataModalToggle !== null && importDataModalToggle !== void 0 ? importDataModalToggle : false,
    submitBtnText: i18n.IMPORT_TIMELINE_BTN_TITLE,
    subtitle: i18n.INITIAL_PROMPT_TEXT,
    title: i18n.IMPORT_TIMELINE
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: _helpers.OPEN_TIMELINE_CLASS_NAME
  }, !!timelineFilter && timelineFilter, /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    "data-test-subj": "search-row",
    favoriteCount: favoriteCount,
    onlyFavorites: onlyFavorites,
    onQueryChange: onQueryChange,
    onToggleOnlyFavorites: onToggleOnlyFavorites,
    query: query,
    timelineType: timelineType
  }, SearchRowContent), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "query-message"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SHOWING, ' ', timelineType === _timeline.TimelineType.template ? nTemplates : nTimelines))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, timelineStatus !== _timeline.TimelineStatus.immutable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "selected-count"
  }, timelineType === _timeline.TimelineType.template ? i18n.SELECTED_TEMPLATES(selectedItems.length) : i18n.SELECTED_TIMELINES(selectedItems.length)), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "batchActions",
    iconSide: "right",
    iconType: "arrowDown",
    popoverContent: getBatchItemsPopoverContent,
    "data-test-subj": "utility-bar-action"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "utility-bar-action-button"
  }, i18n.BATCH_ACTIONS))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "refreshButton",
    iconSide: "right",
    iconType: "refresh",
    onClick: onRefreshBtnClick
  }, i18n.REFRESH)))), /*#__PURE__*/_react.default.createElement(_timelines_table.TimelinesTable, {
    actionTimelineToShow: actionTimelineToShow,
    "data-test-subj": "timelines-table",
    deleteTimelines: deleteTimelines,
    defaultPageSize: defaultPageSize,
    loading: isLoading,
    itemIdToExpandedNotesRowMap: itemIdToExpandedNotesRowMap,
    enableExportTimelineDownloader: enableExportTimelineDownloader,
    onCreateRule: onCreateRule,
    onCreateRuleFromEql: onCreateRuleFromEql,
    onOpenDeleteTimelineModal: onOpenDeleteTimelineModal,
    onOpenTimeline: onOpenTimeline,
    onSelectionChange: onSelectionChange,
    onTableChange: onTableChange,
    onToggleShowNotes: onToggleShowNotes,
    pageIndex: pageIndex,
    pageSize: pageSize,
    searchResults: searchResults,
    showExtendedColumns: true,
    sortDirection: sortDirection,
    sortField: sortField,
    timelineType: timelineType,
    tableRef: tableRef,
    totalSearchResultsCount: totalSearchResultsCount
  })));
});
exports.OpenTimeline = OpenTimeline;
OpenTimeline.displayName = 'OpenTimeline';