"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteTimelineModalOverlay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = require("styled-components");
var _reactRouterDom = require("react-router-dom");
var _delete_timeline_modal = require("./delete_timeline_modal");
var _timeline = require("../../../../../common/api/timeline");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemovePopover = (0, _styledComponents.createGlobalStyle)`
div[data-popover-open] {
  display: none;
}
`;
/**
 * Renders a button that when clicked, displays the `Delete Timeline` modal
 */
const DeleteTimelineModalOverlay = /*#__PURE__*/_react.default.memo(({
  deleteTimelines,
  isModalOpen,
  savedObjectIds,
  title,
  onComplete,
  savedSearchIds
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    tabName: timelineType
  } = (0, _reactRouterDom.useParams)();
  const internalCloseModal = (0, _react.useCallback)(() => {
    if (onComplete != null) {
      onComplete();
    }
  }, [onComplete]);
  const onDelete = (0, _react.useCallback)(() => {
    if (savedObjectIds.length > 0 && savedSearchIds != null && savedSearchIds.length > 0) {
      deleteTimelines(savedObjectIds, savedSearchIds);
      addSuccess({
        title: timelineType === _timeline.TimelineType.template ? i18n.SUCCESSFULLY_DELETED_TIMELINE_TEMPLATES(savedObjectIds.length) : i18n.SUCCESSFULLY_DELETED_TIMELINES(savedObjectIds.length)
      });
    } else if (savedObjectIds.length > 0) {
      deleteTimelines(savedObjectIds);
      addSuccess({
        title: timelineType === _timeline.TimelineType.template ? i18n.SUCCESSFULLY_DELETED_TIMELINE_TEMPLATES(savedObjectIds.length) : i18n.SUCCESSFULLY_DELETED_TIMELINES(savedObjectIds.length)
      });
    }
    if (onComplete != null) {
      onComplete();
    }
  }, [deleteTimelines, savedObjectIds, onComplete, addSuccess, timelineType, savedSearchIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalOpen && /*#__PURE__*/_react.default.createElement(RemovePopover, {
    "data-test-subj": "remove-popover"
  }), isModalOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: _delete_timeline_modal.DELETE_TIMELINE_MODAL_WIDTH,
    onClose: internalCloseModal
  }, /*#__PURE__*/_react.default.createElement(_delete_timeline_modal.DeleteTimelineModal, {
    "data-test-subj": "delete-timeline-modal",
    onDelete: onDelete,
    title: title,
    closeModal: internalCloseModal
  })) : null);
});
exports.DeleteTimelineModalOverlay = DeleteTimelineModalOverlay;
DeleteTimelineModalOverlay.displayName = 'DeleteTimelineModalOverlay';