"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _timeline = require("../../timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _renderers = require("../../timeline/body/renderers");
var _default_cell_renderer = require("../../timeline/cell_rendering/default_cell_renderer");
var _custom_portal = require("./custom_portal");
var _use_selector = require("../../../../common/hooks/use_selector");
var _selectors = require("../../../../common/store/selectors");
var _pane = require("./pane.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutPaneComponent = ({
  timelineId,
  visible = true
}) => {
  var _useShallowEqualSelec;
  const ref = (0, _react.useRef)(null);
  const isFullScreen = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(_selectors.inputsSelectors.timelineFullScreenSelector)) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : false;
  const styles = (0, _pane.usePaneStyles)();
  const wrapperClassName = (0, _classnames.default)('timeline-wrapper', styles, {
    'timeline-wrapper--full-screen': isFullScreen,
    'timeline-wrapper--hidden': !visible
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "flyout-pane",
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_custom_portal.EuiPortal, {
    insert: {
      sibling: !visible ? ref === null || ref === void 0 ? void 0 : ref.current : null,
      position: 'after'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "timeline-wrapper",
    className: wrapperClassName
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-label": i18n.TIMELINE_DESCRIPTION,
    "data-test-subj": "timeline-flyout",
    className: "timeline-flyout"
  }, /*#__PURE__*/_react.default.createElement(_timeline.StatefulTimeline, {
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    timelineId: timelineId
  })))), visible && /*#__PURE__*/_react.default.createElement(_pane.OverflowHiddenGlobalStyles, null));
};
const Pane = /*#__PURE__*/_react.default.memo(FlyoutPaneComponent);
exports.Pane = Pane;
Pane.displayName = 'Pane';