"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAVED_CHANGES = exports.UNSAVED = exports.TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = exports.SAVED = exports.READ_MORE = exports.INSPECT_TIMELINE_TITLE = exports.CLOSE_TIMELINE_OR_TEMPLATE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSE_TIMELINE_OR_TEMPLATE = isTimeline => _i18n.i18n.translate('xpack.securitySolution.timeline.flyout.header.closeTimelineButtonLabel', {
  defaultMessage: 'Close {isTimeline, select, true {timeline} false {template}}',
  values: {
    isTimeline
  }
});
exports.CLOSE_TIMELINE_OR_TEMPLATE = CLOSE_TIMELINE_OR_TEMPLATE;
const UNSAVED = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.unsavedLabel', {
  defaultMessage: 'Unsaved'
});
exports.UNSAVED = UNSAVED;
const SAVED = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.savedLabel', {
  defaultMessage: 'Saved'
});
exports.SAVED = SAVED;
const UNSAVED_CHANGES = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.hasChangesLabel', {
  defaultMessage: 'Unsaved changes'
});
exports.UNSAVED_CHANGES = UNSAVED_CHANGES;
const INSPECT_TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.inspectTimelineTitle', {
  defaultMessage: 'Timeline'
});
exports.INSPECT_TIMELINE_TITLE = INSPECT_TIMELINE_TITLE;
const READ_MORE = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.readMore', {
  defaultMessage: 'Read More'
});
exports.READ_MORE = READ_MORE;
const TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = ({
  isOpen,
  title
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.properties.timelineToggleButtonAriaLabel', {
  values: {
    isOpen,
    title
  },
  defaultMessage: '{isOpen, select, false {Open} true {Close} other {Toggle}} timeline {title}'
});
exports.TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = TIMELINE_TOGGLE_BUTTON_ARIA_LABEL;