"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineStatusByIdSelector = void 0;
var _reselect = require("reselect");
var _timeline = require("../../../../../common/api/timeline");
var _timeline2 = require("../../../store/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineStatusByIdSelector = () => (0, _reselect.createSelector)(_timeline2.timelineSelectors.selectTimeline, timeline => {
  var _timeline$status, _timeline$updated, _timeline$isSaving, _timeline$isLoading, _timeline$changed, _timeline$show;
  return {
    status: (_timeline$status = timeline === null || timeline === void 0 ? void 0 : timeline.status) !== null && _timeline$status !== void 0 ? _timeline$status : _timeline.TimelineStatus.draft,
    updated: (_timeline$updated = timeline === null || timeline === void 0 ? void 0 : timeline.updated) !== null && _timeline$updated !== void 0 ? _timeline$updated : undefined,
    isSaving: (_timeline$isSaving = timeline === null || timeline === void 0 ? void 0 : timeline.isSaving) !== null && _timeline$isSaving !== void 0 ? _timeline$isSaving : undefined,
    isLoading: (_timeline$isLoading = timeline === null || timeline === void 0 ? void 0 : timeline.isLoading) !== null && _timeline$isLoading !== void 0 ? _timeline$isLoading : undefined,
    changed: (_timeline$changed = timeline === null || timeline === void 0 ? void 0 : timeline.changed) !== null && _timeline$changed !== void 0 ? _timeline$changed : undefined,
    show: (_timeline$show = timeline === null || timeline === void 0 ? void 0 : timeline.show) !== null && _timeline$show !== void 0 ? _timeline$show : undefined
  };
});
exports.getTimelineStatusByIdSelector = getTimelineStatusByIdSelector;