"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeaderPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/kibana-react-plugin/common");
var _helpers = require("../../../../common/utils/global_query_string/helpers");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline = require("../../../store/timeline");
var _kibana = require("../../../../common/lib/kibana");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _helpers2 = require("../../timeline/helpers");
var _kuery = require("../../../../common/lib/kuery");
var _model = require("../../../../common/store/sourcerer/model");
var _active_timelines = require("./active_timelines");
var i18n = _interopRequireWildcard(require("./translations"));
var _action_menu = require("../action_menu");
var _helpers3 = require("../../timeline/properties/helpers");
var _timeline_status_info = require("./timeline_status_info");
var _defaults = require("../../../store/timeline/defaults");
var _add_timeline_button = require("../add_timeline_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeaderPanelContentFlexGroupContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  overflow-x: auto;
`;
const ActiveTimelinesContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
`;
const TimelinePanel = (0, _common2.euiStyled)(_eui.EuiPanel)`
  backgroundColor: ${props => props.theme.eui.euiColorEmptyShade};
  color: ${props => props.theme.eui.euiTextColor};
  padding-inline: ${props => props.theme.eui.euiSizeM};
  border-radius: ${({
  $isOpen,
  theme
}) => $isOpen ? theme.eui.euiBorderRadius : '0px'};
`;
const FlyoutHeaderPanelComponent = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    activeTab,
    dataProviders,
    kqlQuery,
    title,
    timelineType,
    status: timelineStatus,
    updated,
    show,
    filters,
    kqlMode,
    changed = false
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['activeTab', 'dataProviders', 'kqlQuery', 'status', 'title', 'timelineType', 'updated', 'show', 'filters', 'kqlMode', 'changed'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const isDataInTimeline = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(dataProviders) || !(0, _fp.isEmpty)((0, _fp.get)('filterQuery.kuery.expression', kqlQuery)), [dataProviders, kqlQuery]);
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getKqlFilterQuerySelector(), []);
  const kqlQueryTimeline = (0, _reactRedux.useSelector)(state => getKqlQueryTimeline(state, timelineId));
  const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(kqlQueryTimeline) && timelineType === 'template' ? ' ' : kqlQueryTimeline !== null && kqlQueryTimeline !== void 0 ? kqlQueryTimeline : '';
  const kqlQueryObj = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression,
    language: 'kuery'
  }), [kqlQueryExpression]);
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery: kqlQueryObj,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, filters, indexPattern, kqlMode, kqlQueryObj]);
  const handleClose = (0, _react.useCallback)(() => {
    (0, _helpers.createHistoryEntry)();
    dispatch(_timeline.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
    (0, _helpers2.focusActiveTimelineButton)();
  }, [dispatch, timelineId]);
  return /*#__PURE__*/_react.default.createElement(TimelinePanel, {
    $isOpen: show,
    grow: false,
    paddingSize: "s",
    hasShadow: false,
    "data-test-subj": "timeline-flyout-header-panel",
    "data-show": show
  }, /*#__PURE__*/_react.default.createElement(FlyoutHeaderPanelContentFlexGroupContainer, {
    className: "eui-scrollBar",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, !show ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_timeline_button.AddTimelineButton, {
    timelineId: timelineId
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_helpers3.AddToFavoritesButton, {
    timelineId: timelineId,
    compact: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ActiveTimelinesContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_active_timelines.ActiveTimelines, {
    timelineId: timelineId,
    timelineType: timelineType,
    timelineTitle: title,
    isOpen: show
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timeline_status_info.TimelineStatusInfo, {
    status: timelineStatus,
    updated: updated,
    changed: changed
  })))), show && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_action_menu.TimelineActionMenu, {
    timelineId: timelineId,
    activeTab: activeTab,
    isInspectButtonDisabled: !isDataInTimeline || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default'),
    "data-test-subj": "close-timeline",
    iconType: "cross",
    onClick: handleClose
  })))))));
};
const FlyoutHeaderPanel = /*#__PURE__*/_react.default.memo(FlyoutHeaderPanelComponent);
exports.FlyoutHeaderPanel = FlyoutHeaderPanel;