"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAVED_TIMELINE_WARNING = exports.TITLE = exports.TIMELINE_TITLE = exports.TIMELINE_DESCRIPTION = exports.SAVE_TOUR_TITLE = exports.SAVE_TOUR_CLOSE = exports.SAVE_TIMELINE_TEMPLATE = exports.SAVE_TIMELINE_BTN_LABEL = exports.SAVE_TIMELINE_BTN = exports.SAVE_TIMELINE = exports.SAVE_AS_NEW = exports.SAVE = exports.OPTIONAL = exports.OPEN_TIMELINE_BTN_LABEL = exports.OPEN_TIMELINE_BTN = exports.NEW_TIMELINE_BTN = exports.NEW_TIMELINE = exports.NEW_TEMPLATE_TIMELINE = exports.NAME_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE = exports.CLOSE_MODAL = exports.CALL_OUT_UNAUTHORIZED_MSG = exports.CALL_OUT_IMMUTABLE = void 0;
var _i18n = require("@kbn/i18n");
var _timeline = require("../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_TIMELINE_BTN = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.newTimelineBtn', {
  defaultMessage: 'New'
});
exports.NEW_TIMELINE_BTN = NEW_TIMELINE_BTN;
const NEW_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.newTimeline', {
  defaultMessage: 'New Timeline'
});
exports.NEW_TIMELINE = NEW_TIMELINE;
const OPEN_TIMELINE_BTN = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.openTimelineBtn', {
  defaultMessage: 'Open'
});
exports.OPEN_TIMELINE_BTN = OPEN_TIMELINE_BTN;
const OPEN_TIMELINE_BTN_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.openTimelineBtnLabel', {
  defaultMessage: 'Open Existing Timeline'
});
exports.OPEN_TIMELINE_BTN_LABEL = OPEN_TIMELINE_BTN_LABEL;
const SAVE_TIMELINE_BTN = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.saveTimelineBtn', {
  defaultMessage: 'Save'
});
exports.SAVE_TIMELINE_BTN = SAVE_TIMELINE_BTN;
const SAVE_TIMELINE_BTN_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.saveTimelineBtnLabel', {
  defaultMessage: 'Save currently opened Timeline'
});
exports.SAVE_TIMELINE_BTN_LABEL = SAVE_TIMELINE_BTN_LABEL;
const NEW_TEMPLATE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.flyout.timeline.actionMenu.newTimelineTemplate', {
  defaultMessage: 'New Timeline template'
});
exports.NEW_TEMPLATE_TIMELINE = NEW_TEMPLATE_TIMELINE;
const CALL_OUT_UNAUTHORIZED_MSG = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.unauthorized.message.description', {
  defaultMessage: 'You can use Timeline to investigate events, but you do not have the required permissions to save timelines for future use. If you need to save timelines, contact your Kibana administrator.'
});
exports.CALL_OUT_UNAUTHORIZED_MSG = CALL_OUT_UNAUTHORIZED_MSG;
const CALL_OUT_IMMUTABLE = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.immutable.message.description', {
  defaultMessage: 'This prebuilt timeline template cannot be modified. To make changes, please duplicate this template and make modifications to the duplicate template.'
});
exports.CALL_OUT_IMMUTABLE = CALL_OUT_IMMUTABLE;
const SAVE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.header', {
  defaultMessage: 'Save Timeline'
});
exports.SAVE_TIMELINE = SAVE_TIMELINE;
const SAVE_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.header', {
  defaultMessage: 'Save Timeline Template'
});
exports.SAVE_TIMELINE_TEMPLATE = SAVE_TIMELINE_TEMPLATE;
const SAVE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimeline.save.title', {
  defaultMessage: 'Save'
});
exports.SAVE = SAVE;
const NAME_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimelineTemplate.modal.header', {
  defaultMessage: 'Name Timeline Template'
});
exports.NAME_TIMELINE_TEMPLATE = NAME_TIMELINE_TEMPLATE;
const DISCARD_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.discard.title', {
  defaultMessage: 'Discard Timeline'
});
exports.DISCARD_TIMELINE = DISCARD_TIMELINE;
const DISCARD_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.discard.title', {
  defaultMessage: 'Discard Timeline Template'
});
exports.DISCARD_TIMELINE_TEMPLATE = DISCARD_TIMELINE_TEMPLATE;
const CLOSE_MODAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.close.title', {
  defaultMessage: 'Close'
});
exports.CLOSE_MODAL = CLOSE_MODAL;
const UNSAVED_TIMELINE_WARNING = timelineType => _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.warning.title', {
  values: {
    timeline: timelineType === _timeline.TimelineType.template ? 'timeline template' : 'timeline'
  },
  defaultMessage: 'You have an unsaved {timeline}. Do you wish to save it?'
});
exports.UNSAVED_TIMELINE_WARNING = UNSAVED_TIMELINE_WARNING;
const TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.titleAriaLabel', {
  defaultMessage: 'Title'
});
exports.TIMELINE_TITLE = TIMELINE_TITLE;
const TIMELINE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.descriptionLabel', {
  defaultMessage: 'Description'
});
exports.TIMELINE_DESCRIPTION = TIMELINE_DESCRIPTION;
const OPTIONAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.optionalLabel', {
  defaultMessage: 'Optional'
});
exports.OPTIONAL = OPTIONAL;
const SAVE_TOUR_CLOSE = _i18n.i18n.translate('xpack.securitySolution.timeline.flyout.saveTour.closeButton', {
  defaultMessage: 'Close'
});
exports.SAVE_TOUR_CLOSE = SAVE_TOUR_CLOSE;
const TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.title', {
  defaultMessage: 'Title'
});
exports.TITLE = TITLE;
const SAVE_TOUR_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.flyout.saveTour.title', {
  defaultMessage: 'Timeline changes now require manual saves'
});
exports.SAVE_TOUR_TITLE = SAVE_TOUR_TITLE;
const SAVE_AS_NEW = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.saveAsNew', {
  defaultMessage: 'Save as new timeline'
});
exports.SAVE_AS_NEW = SAVE_AS_NEW;