"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineActionMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _common = require("../../../../../common");
var _inspect = require("../../../../common/components/inspect");
var _constants = require("../../../../common/store/inputs/constants");
var _add_to_case_button = require("../add_to_case_button");
var _new_timeline = require("./new_timeline");
var _save_timeline_button = require("./save_timeline_button");
var _open_timeline = require("./open_timeline");
var _step_config = require("../../timeline/tour/step_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VerticalDivider = _styledComponents.default.span`
  width: 0px;
  height: 20px;
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const TimelineActionMenuComponent = ({
  mode = 'normal',
  timelineId,
  activeTab,
  isInspectButtonDisabled
}) => {
  const {
    cases
  } = (0, _kibana_react.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_common.APP_ID]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.ACTION_MENU,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    responsive: false,
    "data-test-subj": "timeline-action-menu"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "new-timeline-action"
  }, /*#__PURE__*/_react.default.createElement(_new_timeline.NewTimelineAction, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "open-timeline-action"
  }, /*#__PURE__*/_react.default.createElement(_open_timeline.OpenTimelineAction, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "inspect-timeline-action"
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    compact: mode === 'compact',
    queryId: `${timelineId}-${activeTab}`,
    inputId: _constants.InputsModelId.timeline,
    isDisabled: isInspectButtonDisabled,
    title: ""
  })), userCasesPermissions.create && userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(VerticalDivider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_to_case_button.AddToCaseButton, {
    timelineId: timelineId
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "save-timeline-action"
  }, /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: timelineId
  })));
};
const TimelineActionMenu = /*#__PURE__*/_react.default.memo(TimelineActionMenuComponent);
exports.TimelineActionMenu = TimelineActionMenu;