"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColors = useColors;
var _uiTheme = require("@kbn/ui-theme");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get access to Kibana-theme based colors.
 */
function useColors() {
  return (0, _react.useMemo)(() => {
    return {
      copyableFieldBackground: _uiTheme.euiThemeVars.euiColorLightShade,
      descriptionText: _uiTheme.euiThemeVars.euiTextColor,
      full: _uiTheme.euiThemeVars.euiColorFullShade,
      graphControls: _uiTheme.euiThemeVars.euiColorDarkestShade,
      graphControlsBackground: _uiTheme.euiThemeVars.euiColorEmptyShade,
      graphControlsBorderColor: _uiTheme.euiThemeVars.euiColorLightShade,
      processBackingFill: `${_uiTheme.euiThemeVars.euiColorPrimary}${_uiTheme.darkMode ? '1F' : '0F'}`,
      // Add opacity 0F = 6% , 1F = 12%
      resolverBackground: _uiTheme.euiThemeVars.euiColorEmptyShade,
      resolverEdge: _uiTheme.darkMode ? _uiTheme.euiThemeVars.euiColorLightShade : _uiTheme.euiThemeVars.euiColorLightestShade,
      resolverBreadcrumbBackground: _uiTheme.euiThemeVars.euiColorLightestShade,
      resolverEdgeText: _uiTheme.darkMode ? _uiTheme.euiThemeVars.euiColorFullShade : _uiTheme.euiThemeVars.euiColorDarkShade,
      triggerBackingFill: `${_uiTheme.euiThemeVars.euiColorDanger}${_uiTheme.darkMode ? '1F' : '0F'}`,
      pillStroke: _uiTheme.euiThemeVars.euiColorLightShade,
      linkColor: _uiTheme.euiThemeVars.euiLinkColor
    };
  }, []);
}