"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutotuneTimerange = useAutotuneTimerange;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _use_formatted_date = require("./panels/use_formatted_date");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAutotuneTimerange({
  id
}) {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    from: detectedFrom,
    to: detectedTo
  } = (0, _reactRedux.useSelector)(state => {
    const detectedBounds = selectors.detectedBounds(state.analyzer[id]);
    return {
      from: detectedBounds !== null && detectedBounds !== void 0 && detectedBounds.from ? detectedBounds.from : undefined,
      to: detectedBounds !== null && detectedBounds !== void 0 && detectedBounds.to ? detectedBounds.to : undefined
    };
  });
  const detectedFormattedFrom = (0, _use_formatted_date.useFormattedDate)(detectedFrom);
  const detectedFormattedTo = (0, _use_formatted_date.useFormattedDate)(detectedTo);
  const successMessage = (0, _react.useMemo)(() => {
    return _i18n.i18n.translate('xpack.securitySolution.resolver.unboundedRequest.toast', {
      defaultMessage: `No results found in the selected time, expanded to {from} - {to}.`,
      values: {
        from: detectedFormattedFrom,
        to: detectedFormattedTo
      }
    });
  }, [detectedFormattedFrom, detectedFormattedTo]);
  (0, _react.useEffect)(() => {
    if (detectedFrom || detectedTo) {
      addSuccess(successMessage);
    }
  }, [addSuccess, successMessage, detectedFrom, detectedTo]);
}