"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockResolver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _immer = require("immer");
var _resolver_without_providers = require("../../view/resolver_without_providers");
var _side_effect_context = require("../../view/side_effect_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

(0, _immer.enableMapSet)();
/**
 * This is a mock Resolver component. It is intended to be used with `enzyme` tests via the `Simulator` class. It wraps Resolver in the required providers:
 *  * `i18n`
 *  * `Router` using a provided `History`
 *  * `SideEffectContext.Provider` using side effect simulator it creates
 *  * `KibanaContextProvider` using a provided `CoreStart` instance
 *  * `react-redux`'s `Provider` using a provided `Store`.
 *
 * Resolver needs to measure its size in the DOM. The `SideEffectSimulator` instance can fake the size of an element.
 * However in tests, React doesn't have good DOM reconciliation and the root element is often swapped out. When the
 * element is replaced, the fake dimensions stop being applied. In order to get around this issue, this component will
 * trigger a simulated resize on the root node reference any time it changes. This simulates the layout process a real
 * browser would do when an element is attached to the DOM.
 */
// eslint-disable-next-line react/display-name
const MockResolver = /*#__PURE__*/_react.default.memo(props => {
  const [resolverElement, setResolverElement] = (0, _react.useState)(null);

  // Get a ref to the underlying Resolver element so we can resize.
  // Use a callback function because the underlying DOM node can change. In fact, `enzyme` seems to change it a lot.
  const resolverRef = (0, _react.useCallback)(element => {
    setResolverElement(element);
  }, []);

  // Resize the Resolver element to match the passed in props. Resolver is size dependent.
  (0, _react.useEffect)(() => {
    if (resolverElement) {
      var _props$rasterWidth, _props$rasterHeight;
      const size = {
        width: (_props$rasterWidth = props.rasterWidth) !== null && _props$rasterWidth !== void 0 ? _props$rasterWidth : 1600,
        height: (_props$rasterHeight = props.rasterHeight) !== null && _props$rasterHeight !== void 0 ? _props$rasterHeight : 1200,
        x: 0,
        y: 0,
        bottom: 0,
        left: 0,
        top: 0,
        right: 0,
        toJSON() {
          return this;
        }
      };
      props.sideEffectSimulator.controls.simulateElementResize(resolverElement, size);
    }
  }, [props.rasterWidth, props.rasterHeight, props.sideEffectSimulator.controls, resolverElement]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: props.history
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: props.coreStart
  }, /*#__PURE__*/_react.default.createElement(_side_effect_context.SideEffectContext.Provider, {
    value: props.sideEffectSimulator.mock
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: props.store
  }, /*#__PURE__*/_react.default.createElement(_resolver_without_providers.ResolverWithoutProviders, {
    ref: resolverRef,
    databaseDocumentID: props.databaseDocumentID,
    resolverComponentInstanceID: props.resolverComponentInstanceID,
    indices: props.indices,
    shouldUpdate: props.shouldUpdate,
    filters: props.filters
  }))))));
});
exports.MockResolver = MockResolver;