"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialAnalyzerState = exports.analyzerReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _reduceReducers = _interopRequireDefault(require("reduce-reducers"));
var _helpers = require("./helpers");
var _methods = require("./camera/methods");
var _selectors = require("./selectors");
var _reducer = require("./camera/reducer");
var _reducer2 = require("./data/reducer");
var _scaling_constants = require("./camera/scaling_constants");
var _isometric_taxi_layout = require("../models/indexed_process_tree/isometric_taxi_layout");
var _actions = require("./actions");
var _action = require("./data/action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialAnalyzerState = {};
exports.initialAnalyzerState = initialAnalyzerState;
const uiReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialAnalyzerState).withHandling((0, _helpers.immerCase)(_actions.createResolver, (draft, {
  id
}) => {
  if (!draft[id]) {
    draft[id] = _helpers.EMPTY_RESOLVER;
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_actions.clearResolver, (draft, {
  id
}) => {
  delete draft[id];
  return draft;
})).withHandling((0, _helpers.immerCase)(_actions.appReceivedNewExternalProperties, (draft, {
  id,
  resolverComponentInstanceID,
  locationSearch
}) => {
  draft[id].ui.locationSearch = locationSearch;
  draft[id].ui.resolverComponentInstanceID = resolverComponentInstanceID;
})).withHandling((0, _helpers.immerCase)(_action.serverReturnedResolverData, (draft, {
  id,
  result
}) => {
  draft[id].ui.ariaActiveDescendant = result.originID;
  draft[id].ui.selectedNode = result.originID;
  return draft;
})).withHandling((0, _helpers.immerCase)(_actions.userFocusedOnResolverNode, (draft, {
  id,
  nodeID,
  time
}) => {
  draft[id].ui.ariaActiveDescendant = nodeID;
  const position = (0, _isometric_taxi_layout.nodePosition)((0, _selectors.layout)(draft[id]), nodeID);
  if (position) {
    draft[id].camera = (0, _methods.animatePanning)(draft[id].camera, time, position, _scaling_constants.panAnimationDuration);
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_actions.userSelectedResolverNode, (draft, {
  id,
  nodeID,
  time
}) => {
  draft[id].ui.selectedNode = nodeID;
  draft[id].ui.ariaActiveDescendant = nodeID;
  const position = (0, _isometric_taxi_layout.nodePosition)((0, _selectors.layout)(draft[id]), nodeID);
  if (position) {
    draft[id].camera = (0, _methods.animatePanning)(draft[id].camera, time, position, _scaling_constants.panAnimationDuration);
  }
  return draft;
})).build();
const analyzerReducer = (0, _reduceReducers.default)(initialAnalyzerState, _reducer.cameraReducer, _reducer2.dataReducer, uiReducer);
exports.analyzerReducer = analyzerReducer;