"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverMiddlewareFactory = void 0;
var _resolver_tree_fetcher = require("./resolver_tree_fetcher");
var _related_events_fetcher = require("./related_events_fetcher");
var _current_related_event_fetcher = require("./current_related_event_fetcher");
var _node_data_fetcher = require("./node_data_fetcher");
var Actions = _interopRequireWildcard(require("../actions"));
var DataActions = _interopRequireWildcard(require("../data/action"));
var CameraActions = _interopRequireWildcard(require("../camera/action"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolverActions = [...Object.values(Actions).map(action => action.type), ...Object.values(DataActions).map(action => action.type), ...Object.values(CameraActions).map(action => action.type)];

/**
 * Helper function to determine if analyzer is active (resolver middleware should be run)
 * analyzer is considered active if: action is not clean up
 * @param state analyzer state
 * @param action dispatched action
 * @returns boolean of whether the analyzer of id has an store in redux
 */
function isAnalyzerActive(action) {
  // middleware shouldn't run after clear resolver
  return !Actions.clearResolver.match(action) && resolverActions.includes(action.type);
}

/**
 * The `redux` middleware that the application uses to trigger side effects.
 * All data fetching should be done here.
 * For actions that the application triggers directly, use `app` as a prefix for the type.
 * For actions that are triggered as a result of server interaction, use `server` as a prefix for the type.
 */
const resolverMiddlewareFactory = dataAccessLayer => {
  return api => next => {
    const resolverTreeFetcher = (0, _resolver_tree_fetcher.ResolverTreeFetcher)(dataAccessLayer, api);
    const relatedEventsFetcher = (0, _related_events_fetcher.RelatedEventsFetcher)(dataAccessLayer, api);
    const currentRelatedEventFetcher = (0, _current_related_event_fetcher.CurrentRelatedEventFetcher)(dataAccessLayer, api);
    const nodeDataFetcher = (0, _node_data_fetcher.NodeDataFetcher)(dataAccessLayer, api);
    return async action => {
      var _action$payload;
      next(action);
      if ((_action$payload = action.payload) !== null && _action$payload !== void 0 && _action$payload.id && isAnalyzerActive(action)) {
        resolverTreeFetcher(action.payload.id);
        relatedEventsFetcher(action.payload.id);
        nodeDataFetcher(action.payload.id);
        currentRelatedEventFetcher(action.payload.id);
      }
    };
  };
};
exports.resolverMiddlewareFactory = resolverMiddlewareFactory;