"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverStoreFactory = void 0;
var _redux = require("redux");
var _developmentOnly = require("redux-devtools-extension/developmentOnly");
var _reducer = require("./reducer");
var _middleware = require("./middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolverStoreFactory = dataAccessLayer => {
  const actionsDenylist = ['userMovedPointer'];
  const composeEnhancers = (0, _developmentOnly.composeWithDevTools)({
    name: 'Resolver',
    actionsBlacklist: actionsDenylist
  });
  const middlewareEnhancer = (0, _redux.applyMiddleware)((0, _middleware.resolverMiddlewareFactory)(dataAccessLayer));
  return (0, _redux.createStore)(_reducer.analyzerReducer, composeEnhancers(middlewareEnhancer));
};
exports.resolverStoreFactory = resolverStoreFactory;