"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userRequestedAdditionalRelatedEvents = exports.userReloadedResolverNode = exports.serverReturnedResolverData = exports.serverReturnedNodeEventsInCategory = exports.serverReturnedNodeData = exports.serverReturnedCurrentRelatedEventData = exports.serverFailedToReturnResolverData = exports.serverFailedToReturnNodeEventsInCategory = exports.serverFailedToReturnNodeData = exports.serverFailedToReturnCurrentRelatedEventData = exports.appRequestingNodeData = exports.appRequestedResolverData = exports.appRequestedNodeEventsInCategory = exports.appRequestedCurrentRelatedEventData = exports.appAbortedResolverDataRequest = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/security_solution/analyzer');
const serverReturnedResolverData = actionCreator('SERVER_RETURNED_RESOLVER_DATA');
exports.serverReturnedResolverData = serverReturnedResolverData;
const appRequestedNodeEventsInCategory = actionCreator('APP_REQUESTED_NODE_EVENTS_IN_CATEGORY');
exports.appRequestedNodeEventsInCategory = appRequestedNodeEventsInCategory;
const appRequestedResolverData = actionCreator('APP_REQUESTED_RESOLVER_DATA');
exports.appRequestedResolverData = appRequestedResolverData;
const userRequestedAdditionalRelatedEvents = actionCreator('USER_REQUESTED_ADDITIONAL_RELATED_EVENTS');
exports.userRequestedAdditionalRelatedEvents = userRequestedAdditionalRelatedEvents;
const serverFailedToReturnNodeEventsInCategory = actionCreator('SERVER_FAILED_TO_RETUEN_NODE_EVENTS_IN_CATEGORY');
exports.serverFailedToReturnNodeEventsInCategory = serverFailedToReturnNodeEventsInCategory;
const serverFailedToReturnResolverData = actionCreator('SERVER_FAILED_TO_RETURN_RESOLVER_DATA');
exports.serverFailedToReturnResolverData = serverFailedToReturnResolverData;
const appAbortedResolverDataRequest = actionCreator('APP_ABORTED_RESOLVER_DATA_REQUEST');
exports.appAbortedResolverDataRequest = appAbortedResolverDataRequest;
const serverReturnedNodeEventsInCategory = actionCreator('SERVER_RETURNED_NODE_EVENTS_IN_CATEGORY');

/**
 * When events are returned for a set of graph nodes. For Endpoint graphs the events returned are process lifecycle events.
 */
exports.serverReturnedNodeEventsInCategory = serverReturnedNodeEventsInCategory;
const serverReturnedNodeData = actionCreator('SERVER_RETURNED_NODE_DATA');

/**
 * When the middleware kicks off the request for node data to the server.
 */
exports.serverReturnedNodeData = serverReturnedNodeData;
const appRequestingNodeData = actionCreator('APP_REQUESTING_NODE_DATA');

/**
 * When the user clicks on a node that was in an error state to reload the node data.
 */
exports.appRequestingNodeData = appRequestingNodeData;
const userReloadedResolverNode = actionCreator('USER_RELOADED_RESOLVER_NODE');

/**
 * When the server returns an error after the app requests node data for a set of nodes.
 */
exports.userReloadedResolverNode = userReloadedResolverNode;
const serverFailedToReturnNodeData = actionCreator('SERVER_FAILED_TO_RETURN_NODE_DATA');
exports.serverFailedToReturnNodeData = serverFailedToReturnNodeData;
const appRequestedCurrentRelatedEventData = actionCreator('APP_REQUESTED_CURRENT_RELATED_EVENT_DATA');
exports.appRequestedCurrentRelatedEventData = appRequestedCurrentRelatedEventData;
const serverFailedToReturnCurrentRelatedEventData = actionCreator('SERVER_FAILED_TO_RETURN_CURRENT_RELATED_EVENT_DATA');
exports.serverFailedToReturnCurrentRelatedEventData = serverFailedToReturnCurrentRelatedEventData;
const serverReturnedCurrentRelatedEventData = actionCreator('SERVER_RETURNED_CURRENT_RELATED_EVENT_DATA');
exports.serverReturnedCurrentRelatedEventData = serverReturnedCurrentRelatedEventData;