"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _risk_score = require("../components/entity_analytics/risk_score");
var _search_strategy = require("../../../common/search_strategy");
var _translations = require("../../app/translations");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _sourcerer = require("../../common/containers/sourcerer");
var _page_wrapper = require("../../common/components/page_wrapper");
var _header_page = require("../../common/components/header_page");
var _landing_page = require("../../common/components/landing_page");
var _header = require("../components/entity_analytics/header");
var _anomalies = require("../components/entity_analytics/anomalies");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _use_risk_engine_status = require("../../entity_analytics/api/hooks/use_risk_engine_status");
var _risk_score_update_panel = require("../../entity_analytics/components/risk_score_update_panel");
var _helper_hooks = require("../../helper_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsComponent = () => {
  const {
    data: riskScoreEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const {
    indicesExist,
    loading: isSourcererLoading,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const isRiskScoreModuleLicenseAvailable = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: sourcererDataView
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "entityAnalyticsPage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.ENTITY_ANALYTICS
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "entityAnalyticsLoader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "entityAnalyticsSections"
  }, (riskScoreEngineStatus === null || riskScoreEngineStatus === void 0 ? void 0 : riskScoreEngineStatus.isUpdateAvailable) && isRiskScoreModuleLicenseAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score_update_panel.RiskScoreUpdatePanel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_header.EntityAnalyticsHeader, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: _search_strategy.RiskScoreEntity.host
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: _search_strategy.RiskScoreEntity.user
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_anomalies.EntityAnalyticsAnomalies, null))))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalytics
  }));
};
const EntityAnalyticsPage = /*#__PURE__*/_react.default.memo(EntityAnalyticsComponent);
exports.EntityAnalyticsPage = EntityAnalyticsPage;