"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataQuality = void 0;
var _common = require("@kbn/cases-plugin/common");
var _ecsDataQualityDashboard = require("@kbn/ecs-data-quality-dashboard");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_assistant_availability = require("../../assistant/use_assistant_availability");
var _types = require("../../app/types");
var _helpers = require("../../common/components/alerts_treemap/lib/helpers");
var _common2 = require("../../common/components/charts/common");
var _header_page = require("../../common/components/header_page");
var _landing_page = require("../../common/components/landing_page");
var _local_storage = require("../../common/components/local_storage");
var _page_wrapper = require("../../common/components/page_wrapper");
var _constants = require("../../../common/constants");
var _sourcerer = require("../../common/containers/sourcerer");
var _kibana = require("../../common/lib/kibana");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'dataQualityDashboardLastChecked';
const comboBoxStyle = {
  width: '322px'
};
const FormControlLayout = (0, _styledComponents.default)(_eui.EuiFormControlLayout)`
  max-width: 500px;
  height: 42px;

  .euiFormControlLayout__childrenWrapper {
    overflow: visible;
  }
`;
const Option = _styledComponents.default.div`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  width: 100%;
`;
const OptionLabel = _styledComponents.default.span`
  font-weight: bold;
`;
const options = [{
  label: i18n.HOT,
  value: 'hot'
}, {
  label: i18n.WARM,
  value: 'warm'
}, {
  disabled: true,
  label: i18n.COLD,
  value: 'cold'
}, {
  disabled: true,
  label: i18n.FROZEN,
  value: 'frozen'
}, {
  label: i18n.UNMANAGED,
  value: 'unmanaged'
}];
const defaultOptions = [{
  label: i18n.HOT,
  value: 'hot'
}, {
  label: i18n.WARM,
  value: 'warm'
}, {
  label: i18n.UNMANAGED,
  value: 'unmanaged'
}];
const DEFAULT_START_TIME = 'now-7d';
const DEFAULT_END_TIME = 'now';
const renderOption = option => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: `${option.label}: ${(0, _ecsDataQualityDashboard.getIlmPhaseDescription)(option.label)}`
}, /*#__PURE__*/_react.default.createElement(Option, null, /*#__PURE__*/_react.default.createElement(OptionLabel, null, `${option.label}`), ': ', /*#__PURE__*/_react.default.createElement("span", null, (0, _ecsDataQualityDashboard.getIlmPhaseDescription)(option.label))));
const DataQualityComponent = () => {
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const httpFetch = _kibana.KibanaServices.get().http.fetch;
  const {
    baseTheme,
    theme
  } = (0, _common2.useThemes)();
  const toasts = (0, _kibana.useToasts)();
  const addSuccessToast = (0, _react.useCallback)(toast => {
    toasts.addSuccess(toast);
  }, [toasts]);
  const [defaultBytesFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_BYTES_FORMAT);
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const labelInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'labelInput'
  });
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(defaultOptions);
  const {
    indicesExist,
    loading: isSourcererLoading,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    signalIndexName,
    loading: isSignalIndexNameLoading
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    configSettings,
    cases,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const isILMAvailable = configSettings.ILMEnabled;
  const [startDate, setStartTime] = (0, _react.useState)();
  const [endDate, setEndTime] = (0, _react.useState)();
  const onTimeChange = ({
    start,
    end,
    isInvalid
  }) => {
    if (isInvalid) {
      return;
    }
    setStartTime(start);
    setEndTime(end);
  };
  (0, _react.useEffect)(() => {
    if (!isILMAvailable) {
      setStartTime(DEFAULT_START_TIME);
      setEndTime(DEFAULT_END_TIME);
    }
  }, [isILMAvailable]);
  const alertsAndSelectedPatterns = (0, _react.useMemo)(() => signalIndexName != null ? [signalIndexName, ...selectedPatterns] : [...selectedPatterns], [selectedPatterns, signalIndexName]);
  const subtitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, _ecsDataQualityDashboard.DATA_QUALITY_SUBTITLE), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: _ecsDataQualityDashboard.ECS_REFERENCE_URL,
    rel: "noopener noreferrer",
    target: "_blank"
  }, i18n.ELASTIC_COMMON_SCHEMA)), []);
  const ilmPhases = (0, _react.useMemo)(() => selectedOptions.map(({
    label
  }) => label), [selectedOptions]);
  const ilmFormLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: labelInputId
  }, _ecsDataQualityDashboard.ILM_PHASE), [labelInputId]);
  const [lastChecked, setLastChecked] = (0, _local_storage.useLocalStorage)({
    defaultValue: '',
    key: LOCAL_STORAGE_KEY
  });
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const canUserCreateAndReadCases = (0, _react.useCallback)(() => userCasesPermissions.create && userCasesPermissions.read, [userCasesPermissions.create, userCasesPermissions.read]);
  const createCaseFlyout = cases.hooks.useCasesAddToNewCaseFlyout({
    toastContent: i18n.ADD_TO_CASE_SUCCESS
  });
  const openCreateCaseFlyout = (0, _react.useCallback)(({
    comments,
    headerContent
  }) => {
    const attachments = comments.map(x => ({
      comment: x,
      type: _common.AttachmentType.user
    }));
    createCaseFlyout.open({
      attachments,
      headerContent
    });
  }, [createCaseFlyout]);
  const reportDataQualityIndexChecked = (0, _react.useCallback)(params => {
    telemetry.reportDataQualityIndexChecked(params);
  }, [telemetry]);
  const reportDataQualityCheckAllCompleted = (0, _react.useCallback)(params => {
    telemetry.reportDataQualityCheckAllCompleted(params);
  }, [telemetry]);
  if (isSourcererLoading || isSignalIndexNameLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": "ecsDataQualityDashboardLoader"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "ecsDataQualityDashboardPage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: subtitle,
    title: i18n.DATA_QUALITY_TITLE
  }, isILMAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _ecsDataQualityDashboard.INDEX_LIFECYCLE_MANAGEMENT_PHASES
  }, /*#__PURE__*/_react.default.createElement(FormControlLayout, {
    prepend: ilmFormLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: labelInputId,
    "data-test-subj": "selectIlmPhases",
    placeholder: _ecsDataQualityDashboard.SELECT_ONE_OR_MORE_ILM_PHASES,
    renderOption: renderOption,
    selectedOptions: selectedOptions,
    style: comboBoxStyle,
    options: options,
    onChange: setSelectedOptions
  }))), !isILMAvailable && startDate && endDate && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.DATE_PICKER_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: startDate,
    end: endDate,
    onTimeChange: onTimeChange,
    showUpdateButton: false,
    isDisabled: true,
    "data-test-subj": "dataQualityDatePicker"
  }))), /*#__PURE__*/_react.default.createElement(_ecsDataQualityDashboard.DataQualityPanel, {
    addSuccessToast: addSuccessToast,
    baseTheme: baseTheme,
    canUserCreateAndReadCases: canUserCreateAndReadCases,
    defaultBytesFormat: defaultBytesFormat,
    defaultNumberFormat: defaultNumberFormat,
    endDate: endDate,
    getGroupByFieldsOnClick: _helpers.getGroupByFieldsOnClick,
    reportDataQualityCheckAllCompleted: reportDataQualityCheckAllCompleted,
    reportDataQualityIndexChecked: reportDataQualityIndexChecked,
    httpFetch: httpFetch,
    ilmPhases: ilmPhases,
    isAssistantEnabled: hasAssistantPrivilege,
    isILMAvailable: isILMAvailable,
    lastChecked: lastChecked,
    openCreateCaseFlyout: openCreateCaseFlyout,
    patterns: alertsAndSelectedPatterns,
    setLastChecked: setLastChecked,
    startDate: startDate,
    theme: theme
  })) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.dataQuality
  }));
};
DataQualityComponent.displayName = 'DataQualityComponent';
const DataQuality = /*#__PURE__*/_react.default.memo(DataQualityComponent);
exports.DataQuality = DataQuality;