"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTiDataSourcesComplete = exports.useTiDataSources = exports.getTiDataSourcesComplete = exports.getTiDataSources = exports.ID = void 0;
var _operators = require("rxjs/operators");
var _react = require("react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _public = require("@kbn/data-plugin/public");
var _kibana = require("../../../common/lib/kibana");
var _cti = require("../../../../common/search_strategy/security_solution/cti");
var _constants = require("../../../../common/constants");
var _translations = require("../../components/overview_cti_links/translations");
var _constants2 = require("../../../../common/cti/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'ctiEventCountQuery';
exports.ID = ID;
const getTiDataSources = ({
  data,
  defaultIndex,
  timerange,
  signal
}) => data.search.search({
  defaultIndex,
  factoryQueryType: _cti.CtiQueries.dataSource,
  timerange
}, {
  strategy: 'securitySolutionSearchStrategy',
  abortSignal: signal
});
exports.getTiDataSources = getTiDataSources;
const getTiDataSourcesComplete = props => {
  return getTiDataSources(props).pipe((0, _operators.filter)(response => {
    return !(0, _public.isRunningResponse)(response);
  }));
};
exports.getTiDataSourcesComplete = getTiDataSourcesComplete;
const getTiDataSourcesWithOptionalSignal = (0, _securitysolutionHookUtils.withOptionalSignal)(getTiDataSourcesComplete);
const useTiDataSourcesComplete = () => (0, _securitysolutionHookUtils.useObservable)(getTiDataSourcesWithOptionalSignal);
exports.useTiDataSourcesComplete = useTiDataSourcesComplete;
const useTiDataSources = ({
  to,
  from,
  allTiDataSources,
  setQuery,
  deleteQuery
}) => {
  const [tiDataSources, setTiDataSources] = (0, _react.useState)([]);
  const [isInitiallyLoaded, setIsInitiallyLoaded] = (0, _react.useState)(false);
  const {
    data,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultThreatIndices = uiSettings.get(_constants.DEFAULT_THREAT_INDEX_KEY);
  const {
    result,
    start,
    loading
  } = useTiDataSourcesComplete();
  (0, _react.useEffect)(() => {
    start({
      data,
      timerange: to && from ? {
        to,
        from,
        interval: ''
      } : undefined,
      defaultIndex: defaultThreatIndices
    });
  }, [to, from, start, data, defaultThreatIndices]);
  (0, _react.useEffect)(() => {
    if (!loading && result !== null && result !== void 0 && result.rawResponse && result !== null && result !== void 0 && result.inspect && setQuery) {
      var _result$inspect$dsl, _result$inspect;
      setQuery({
        id: ID,
        inspect: {
          dsl: (_result$inspect$dsl = result === null || result === void 0 ? void 0 : (_result$inspect = result.inspect) === null || _result$inspect === void 0 ? void 0 : _result$inspect.dsl) !== null && _result$inspect$dsl !== void 0 ? _result$inspect$dsl : [],
          response: [JSON.stringify(result.rawResponse, null, 2)]
        },
        loading,
        refetch: () => {}
      });
    }
  }, [setQuery, loading, result]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: ID
        });
      }
    };
  }, [deleteQuery]);
  (0, _react.useEffect)(() => {
    if (result && !isInitiallyLoaded) {
      setIsInitiallyLoaded(true);
    }
  }, [isInitiallyLoaded, result]);
  (0, _react.useEffect)(() => {
    if (!loading && result) {
      var _result$rawResponse$a, _result$rawResponse, _result$rawResponse$a2, _result$rawResponse$a3;
      const datasets = (_result$rawResponse$a = result === null || result === void 0 ? void 0 : (_result$rawResponse = result.rawResponse) === null || _result$rawResponse === void 0 ? void 0 : (_result$rawResponse$a2 = _result$rawResponse.aggregations) === null || _result$rawResponse$a2 === void 0 ? void 0 : (_result$rawResponse$a3 = _result$rawResponse$a2.dataset) === null || _result$rawResponse$a3 === void 0 ? void 0 : _result$rawResponse$a3.buckets) !== null && _result$rawResponse$a !== void 0 ? _result$rawResponse$a : [];
      const getChildAggregationValue = aggregation => {
        var _aggregation$buckets, _aggregation$buckets$;
        return aggregation === null || aggregation === void 0 ? void 0 : (_aggregation$buckets = aggregation.buckets) === null || _aggregation$buckets === void 0 ? void 0 : (_aggregation$buckets$ = _aggregation$buckets[0]) === null || _aggregation$buckets$ === void 0 ? void 0 : _aggregation$buckets$.key;
      };
      const integrationMap = datasets.reduce((acc, dataset) => {
        const datasetName = getChildAggregationValue(dataset === null || dataset === void 0 ? void 0 : dataset.name);
        if (datasetName) {
          return {
            ...acc,
            [dataset.key]: {
              dataset: dataset === null || dataset === void 0 ? void 0 : dataset.key,
              name: datasetName,
              dashboardId: getChildAggregationValue(dataset === null || dataset === void 0 ? void 0 : dataset.dashboard),
              count: dataset === null || dataset === void 0 ? void 0 : dataset.doc_count
            }
          };
        } else {
          var _acc$otherTiDatasetKe, _acc$otherTiDatasetKe2, _dataset$doc_count;
          const otherTiDatasetKey = _constants2.OTHER_TI_DATASET_KEY;
          const otherDatasetCount = (_acc$otherTiDatasetKe = (_acc$otherTiDatasetKe2 = acc[otherTiDatasetKey]) === null || _acc$otherTiDatasetKe2 === void 0 ? void 0 : _acc$otherTiDatasetKe2.count) !== null && _acc$otherTiDatasetKe !== void 0 ? _acc$otherTiDatasetKe : 0;
          return {
            ...acc,
            [otherTiDatasetKey]: {
              dataset: otherTiDatasetKey,
              name: _translations.OTHER_DATA_SOURCE_TITLE,
              count: otherDatasetCount + ((_dataset$doc_count = dataset === null || dataset === void 0 ? void 0 : dataset.doc_count) !== null && _dataset$doc_count !== void 0 ? _dataset$doc_count : 0)
            }
          };
        }
      }, {});
      if (Array.isArray(allTiDataSources)) {
        allTiDataSources.forEach(integration => {
          if (!integrationMap[integration.dataset]) {
            integrationMap[integration.dataset] = {
              ...integration,
              count: 0
            };
          }
        });
      }
      setTiDataSources(Object.values(integrationMap));
    }
  }, [result, loading, allTiDataSources]);
  const totalCount = tiDataSources.reduce((acc, val) => acc + val.count, 0);
  return {
    tiDataSources,
    totalCount,
    isInitiallyLoaded
  };
};
exports.useTiDataSources = useTiDataSources;