"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatValue = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressContainer = _styledComponents.default.div`
  margin-left: 8px;
  min-width: 100px;
  @media only screen and (min-width: 1400px) {
    min-width: 200px;
  }
`;
const StatValueComponent = ({
  count,
  isGroupStat,
  isLoading,
  max
}) => {
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const [isInitialLoading, setIsInitialLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (isInitialLoading && !isLoading) {
      setIsInitialLoading(false);
    }
  }, [isLoading, isInitialLoading, setIsInitialLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isGroupStat ? 'default' : 'subdued',
    size: isGroupStat ? 'm' : 's'
  }, (0, _numeral.default)(count).format(defaultNumberFormat))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ProgressContainer, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "stat-value-loading-spinner",
    lines: 1
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    color: isGroupStat ? 'primary' : 'subdued',
    max: max,
    size: "m",
    value: count
  }))));
};
StatValueComponent.displayName = 'StatValueComponent';
const StatValue = /*#__PURE__*/_react.default.memo(StatValueComponent);
exports.StatValue = StatValue;