"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentTimelineCounts = exports.IconWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("../../../../timelines/components/open_timeline/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 8px;
`;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-right: 16px;
`;
const IconWithCount = /*#__PURE__*/_react.default.memo(({
  count,
  icon,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltip
}, /*#__PURE__*/_react.default.createElement(FlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(Icon, {
  color: "subdued",
  size: "s",
  type: icon
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "xs"
}, count)))));
exports.IconWithCount = IconWithCount;
IconWithCount.displayName = 'IconWithCount';
const RecentTimelineCounts = /*#__PURE__*/_react.default.memo(({
  timeline
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(IconWithCount, {
    count: (0, _helpers.getPinnedEventCount)(timeline),
    icon: "pinFilled",
    tooltip: i18n.PINNED_EVENTS
  }), /*#__PURE__*/_react.default.createElement(IconWithCount, {
    count: (0, _helpers.getNotesCount)(timeline),
    icon: "editorComment",
    tooltip: i18n.NOTES
  }));
});
exports.RecentTimelineCounts = RecentTimelineCounts;
RecentTimelineCounts.displayName = 'RecentTimelineCounts';